/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appintegrations.model.AppIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ApplicationAssociationSummary;
import software.amazon.awssdk.services.appintegrations.model.ApplicationAssociationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationAssociationsResponse
extends AppIntegrationsResponse
implements ToCopyableBuilder<Builder, ListApplicationAssociationsResponse> {
    private static final SdkField<List<ApplicationAssociationSummary>> APPLICATION_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationAssociations").getter(ListApplicationAssociationsResponse.getter(ListApplicationAssociationsResponse::applicationAssociations)).setter(ListApplicationAssociationsResponse.setter(Builder::applicationAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationAssociationsResponse.getter(ListApplicationAssociationsResponse::nextToken)).setter(ListApplicationAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationAssociations", APPLICATION_ASSOCIATIONS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ApplicationAssociationSummary> applicationAssociations;
    private final String nextToken;

    private ListApplicationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationAssociations = builder.applicationAssociations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationAssociations() {
        return this.applicationAssociations != null && !(this.applicationAssociations instanceof SdkAutoConstructList);
    }

    public final List<ApplicationAssociationSummary> applicationAssociations() {
        return this.applicationAssociations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationAssociations() ? this.applicationAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationAssociationsResponse)) {
            return false;
        }
        ListApplicationAssociationsResponse other = (ListApplicationAssociationsResponse)((Object)obj);
        return this.hasApplicationAssociations() == other.hasApplicationAssociations() && Objects.equals(this.applicationAssociations(), other.applicationAssociations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationAssociationsResponse").add("ApplicationAssociations", this.hasApplicationAssociations() ? this.applicationAssociations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationAssociations": {
                return Optional.ofNullable(clazz.cast(this.applicationAssociations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationAssociationsResponse, T> g) {
        return obj -> g.apply((ListApplicationAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppIntegrationsResponse.BuilderImpl
    implements Builder {
        private List<ApplicationAssociationSummary> applicationAssociations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationAssociationsResponse model) {
            super(model);
            this.applicationAssociations(model.applicationAssociations);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationAssociationSummary.Builder> getApplicationAssociations() {
            List<ApplicationAssociationSummary.Builder> result = ApplicationAssociationsListCopier.copyToBuilder(this.applicationAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationAssociations(Collection<ApplicationAssociationSummary.BuilderImpl> applicationAssociations) {
            this.applicationAssociations = ApplicationAssociationsListCopier.copyFromBuilder(applicationAssociations);
        }

        @Override
        public final Builder applicationAssociations(Collection<ApplicationAssociationSummary> applicationAssociations) {
            this.applicationAssociations = ApplicationAssociationsListCopier.copy(applicationAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAssociations(ApplicationAssociationSummary ... applicationAssociations) {
            this.applicationAssociations(Arrays.asList(applicationAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationAssociations(Consumer<ApplicationAssociationSummary.Builder> ... applicationAssociations) {
            this.applicationAssociations(Stream.of(applicationAssociations).map(c -> (ApplicationAssociationSummary)((ApplicationAssociationSummary.Builder)ApplicationAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationAssociationsResponse build() {
            return new ListApplicationAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationAssociationsResponse> {
        public Builder applicationAssociations(Collection<ApplicationAssociationSummary> var1);

        public Builder applicationAssociations(ApplicationAssociationSummary ... var1);

        public Builder applicationAssociations(Consumer<ApplicationAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

