/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventIntegrationAssociationsResponse extends AppIntegrationsResponse implements
        ToCopyableBuilder<ListEventIntegrationAssociationsResponse.Builder, ListEventIntegrationAssociationsResponse> {
    private static final SdkField<List<EventIntegrationAssociation>> EVENT_INTEGRATION_ASSOCIATIONS_FIELD = SdkField
            .<List<EventIntegrationAssociation>> builder(MarshallingType.LIST)
            .memberName("EventIntegrationAssociations")
            .getter(getter(ListEventIntegrationAssociationsResponse::eventIntegrationAssociations))
            .setter(setter(Builder::eventIntegrationAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventIntegrationAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventIntegrationAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEventIntegrationAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVENT_INTEGRATION_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<EventIntegrationAssociation> eventIntegrationAssociations;

    private final String nextToken;

    private ListEventIntegrationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.eventIntegrationAssociations = builder.eventIntegrationAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the EventIntegrationAssociations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasEventIntegrationAssociations() {
        return eventIntegrationAssociations != null && !(eventIntegrationAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event integration associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventIntegrationAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The event integration associations.
     */
    public final List<EventIntegrationAssociation> eventIntegrationAssociations() {
        return eventIntegrationAssociations;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEventIntegrationAssociations() ? eventIntegrationAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventIntegrationAssociationsResponse)) {
            return false;
        }
        ListEventIntegrationAssociationsResponse other = (ListEventIntegrationAssociationsResponse) obj;
        return hasEventIntegrationAssociations() == other.hasEventIntegrationAssociations()
                && Objects.equals(eventIntegrationAssociations(), other.eventIntegrationAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEventIntegrationAssociationsResponse")
                .add("EventIntegrationAssociations", hasEventIntegrationAssociations() ? eventIntegrationAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventIntegrationAssociations":
            return Optional.ofNullable(clazz.cast(eventIntegrationAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventIntegrationAssociationsResponse, T> g) {
        return obj -> g.apply((ListEventIntegrationAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppIntegrationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEventIntegrationAssociationsResponse> {
        /**
         * <p>
         * The event integration associations.
         * </p>
         * 
         * @param eventIntegrationAssociations
         *        The event integration associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrationAssociations(Collection<EventIntegrationAssociation> eventIntegrationAssociations);

        /**
         * <p>
         * The event integration associations.
         * </p>
         * 
         * @param eventIntegrationAssociations
         *        The event integration associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventIntegrationAssociations(EventIntegrationAssociation... eventIntegrationAssociations);

        /**
         * <p>
         * The event integration associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventIntegrationAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<EventIntegrationAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventIntegrationAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #eventIntegrationAssociations(List<EventIntegrationAssociation>)}.
         * 
         * @param eventIntegrationAssociations
         *        a consumer that will call methods on {@link List<EventIntegrationAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventIntegrationAssociations(List<EventIntegrationAssociation>)
         */
        Builder eventIntegrationAssociations(Consumer<EventIntegrationAssociation.Builder>... eventIntegrationAssociations);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppIntegrationsResponse.BuilderImpl implements Builder {
        private List<EventIntegrationAssociation> eventIntegrationAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventIntegrationAssociationsResponse model) {
            super(model);
            eventIntegrationAssociations(model.eventIntegrationAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<EventIntegrationAssociation.Builder> getEventIntegrationAssociations() {
            if (eventIntegrationAssociations instanceof SdkAutoConstructList) {
                return null;
            }
            return eventIntegrationAssociations != null ? eventIntegrationAssociations.stream()
                    .map(EventIntegrationAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventIntegrationAssociations(Collection<EventIntegrationAssociation> eventIntegrationAssociations) {
            this.eventIntegrationAssociations = EventIntegrationAssociationsListCopier.copy(eventIntegrationAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventIntegrationAssociations(EventIntegrationAssociation... eventIntegrationAssociations) {
            eventIntegrationAssociations(Arrays.asList(eventIntegrationAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventIntegrationAssociations(
                Consumer<EventIntegrationAssociation.Builder>... eventIntegrationAssociations) {
            eventIntegrationAssociations(Stream.of(eventIntegrationAssociations)
                    .map(c -> EventIntegrationAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventIntegrationAssociations(
                Collection<EventIntegrationAssociation.BuilderImpl> eventIntegrationAssociations) {
            this.eventIntegrationAssociations = EventIntegrationAssociationsListCopier
                    .copyFromBuilder(eventIntegrationAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListEventIntegrationAssociationsResponse build() {
            return new ListEventIntegrationAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
