/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appintegrations.model.ClientAssociationMetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventIntegrationAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventIntegrationAssociation> {
    private static final SdkField<String> EVENT_INTEGRATION_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventIntegrationAssociationArn").getter(EventIntegrationAssociation.getter(EventIntegrationAssociation::eventIntegrationAssociationArn)).setter(EventIntegrationAssociation.setter(Builder::eventIntegrationAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationAssociationArn").build()}).build();
    private static final SdkField<String> EVENT_INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventIntegrationAssociationId").getter(EventIntegrationAssociation.getter(EventIntegrationAssociation::eventIntegrationAssociationId)).setter(EventIntegrationAssociation.setter(Builder::eventIntegrationAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationAssociationId").build()}).build();
    private static final SdkField<String> EVENT_INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventIntegrationName").getter(EventIntegrationAssociation.getter(EventIntegrationAssociation::eventIntegrationName)).setter(EventIntegrationAssociation.setter(Builder::eventIntegrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventIntegrationName").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(EventIntegrationAssociation.getter(EventIntegrationAssociation::clientId)).setter(EventIntegrationAssociation.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> EVENT_BRIDGE_RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBridgeRuleName").getter(EventIntegrationAssociation.getter(EventIntegrationAssociation::eventBridgeRuleName)).setter(EventIntegrationAssociation.setter(Builder::eventBridgeRuleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeRuleName").build()}).build();
    private static final SdkField<Map<String, String>> CLIENT_ASSOCIATION_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ClientAssociationMetadata").getter(EventIntegrationAssociation.getter(EventIntegrationAssociation::clientAssociationMetadata)).setter(EventIntegrationAssociation.setter(Builder::clientAssociationMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAssociationMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_INTEGRATION_ASSOCIATION_ARN_FIELD, EVENT_INTEGRATION_ASSOCIATION_ID_FIELD, EVENT_INTEGRATION_NAME_FIELD, CLIENT_ID_FIELD, EVENT_BRIDGE_RULE_NAME_FIELD, CLIENT_ASSOCIATION_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventIntegrationAssociationArn;
    private final String eventIntegrationAssociationId;
    private final String eventIntegrationName;
    private final String clientId;
    private final String eventBridgeRuleName;
    private final Map<String, String> clientAssociationMetadata;

    private EventIntegrationAssociation(BuilderImpl builder) {
        this.eventIntegrationAssociationArn = builder.eventIntegrationAssociationArn;
        this.eventIntegrationAssociationId = builder.eventIntegrationAssociationId;
        this.eventIntegrationName = builder.eventIntegrationName;
        this.clientId = builder.clientId;
        this.eventBridgeRuleName = builder.eventBridgeRuleName;
        this.clientAssociationMetadata = builder.clientAssociationMetadata;
    }

    public final String eventIntegrationAssociationArn() {
        return this.eventIntegrationAssociationArn;
    }

    public final String eventIntegrationAssociationId() {
        return this.eventIntegrationAssociationId;
    }

    public final String eventIntegrationName() {
        return this.eventIntegrationName;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String eventBridgeRuleName() {
        return this.eventBridgeRuleName;
    }

    public final boolean hasClientAssociationMetadata() {
        return this.clientAssociationMetadata != null && !(this.clientAssociationMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> clientAssociationMetadata() {
        return this.clientAssociationMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventIntegrationAssociationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventIntegrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventIntegrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientAssociationMetadata() ? this.clientAssociationMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventIntegrationAssociation)) {
            return false;
        }
        EventIntegrationAssociation other = (EventIntegrationAssociation)obj;
        return Objects.equals(this.eventIntegrationAssociationArn(), other.eventIntegrationAssociationArn()) && Objects.equals(this.eventIntegrationAssociationId(), other.eventIntegrationAssociationId()) && Objects.equals(this.eventIntegrationName(), other.eventIntegrationName()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.eventBridgeRuleName(), other.eventBridgeRuleName()) && this.hasClientAssociationMetadata() == other.hasClientAssociationMetadata() && Objects.equals(this.clientAssociationMetadata(), other.clientAssociationMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"EventIntegrationAssociation").add("EventIntegrationAssociationArn", (Object)this.eventIntegrationAssociationArn()).add("EventIntegrationAssociationId", (Object)this.eventIntegrationAssociationId()).add("EventIntegrationName", (Object)this.eventIntegrationName()).add("ClientId", (Object)this.clientId()).add("EventBridgeRuleName", (Object)this.eventBridgeRuleName()).add("ClientAssociationMetadata", this.hasClientAssociationMetadata() ? this.clientAssociationMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventIntegrationAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.eventIntegrationAssociationArn()));
            }
            case "EventIntegrationAssociationId": {
                return Optional.ofNullable(clazz.cast(this.eventIntegrationAssociationId()));
            }
            case "EventIntegrationName": {
                return Optional.ofNullable(clazz.cast(this.eventIntegrationName()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "EventBridgeRuleName": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeRuleName()));
            }
            case "ClientAssociationMetadata": {
                return Optional.ofNullable(clazz.cast(this.clientAssociationMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventIntegrationAssociation, T> g) {
        return obj -> g.apply((EventIntegrationAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventIntegrationAssociationArn;
        private String eventIntegrationAssociationId;
        private String eventIntegrationName;
        private String clientId;
        private String eventBridgeRuleName;
        private Map<String, String> clientAssociationMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventIntegrationAssociation model) {
            this.eventIntegrationAssociationArn(model.eventIntegrationAssociationArn);
            this.eventIntegrationAssociationId(model.eventIntegrationAssociationId);
            this.eventIntegrationName(model.eventIntegrationName);
            this.clientId(model.clientId);
            this.eventBridgeRuleName(model.eventBridgeRuleName);
            this.clientAssociationMetadata(model.clientAssociationMetadata);
        }

        public final String getEventIntegrationAssociationArn() {
            return this.eventIntegrationAssociationArn;
        }

        @Override
        public final Builder eventIntegrationAssociationArn(String eventIntegrationAssociationArn) {
            this.eventIntegrationAssociationArn = eventIntegrationAssociationArn;
            return this;
        }

        public final void setEventIntegrationAssociationArn(String eventIntegrationAssociationArn) {
            this.eventIntegrationAssociationArn = eventIntegrationAssociationArn;
        }

        public final String getEventIntegrationAssociationId() {
            return this.eventIntegrationAssociationId;
        }

        @Override
        public final Builder eventIntegrationAssociationId(String eventIntegrationAssociationId) {
            this.eventIntegrationAssociationId = eventIntegrationAssociationId;
            return this;
        }

        public final void setEventIntegrationAssociationId(String eventIntegrationAssociationId) {
            this.eventIntegrationAssociationId = eventIntegrationAssociationId;
        }

        public final String getEventIntegrationName() {
            return this.eventIntegrationName;
        }

        @Override
        public final Builder eventIntegrationName(String eventIntegrationName) {
            this.eventIntegrationName = eventIntegrationName;
            return this;
        }

        public final void setEventIntegrationName(String eventIntegrationName) {
            this.eventIntegrationName = eventIntegrationName;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getEventBridgeRuleName() {
            return this.eventBridgeRuleName;
        }

        @Override
        public final Builder eventBridgeRuleName(String eventBridgeRuleName) {
            this.eventBridgeRuleName = eventBridgeRuleName;
            return this;
        }

        public final void setEventBridgeRuleName(String eventBridgeRuleName) {
            this.eventBridgeRuleName = eventBridgeRuleName;
        }

        public final Map<String, String> getClientAssociationMetadata() {
            if (this.clientAssociationMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.clientAssociationMetadata;
        }

        @Override
        public final Builder clientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
            return this;
        }

        public final void setClientAssociationMetadata(Map<String, String> clientAssociationMetadata) {
            this.clientAssociationMetadata = ClientAssociationMetadataCopier.copy(clientAssociationMetadata);
        }

        public EventIntegrationAssociation build() {
            return new EventIntegrationAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventIntegrationAssociation> {
        public Builder eventIntegrationAssociationArn(String var1);

        public Builder eventIntegrationAssociationId(String var1);

        public Builder eventIntegrationName(String var1);

        public Builder clientId(String var1);

        public Builder eventBridgeRuleName(String var1);

        public Builder clientAssociationMetadata(Map<String, String> var1);
    }
}

