/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these settings
 * only apply to the <code>Scheduled</code> trigger type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledTriggerProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledTriggerProperties.Builder, ScheduledTriggerProperties> {
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduleExpression").getter(getter(ScheduledTriggerProperties::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build())
            .build();

    private static final SdkField<String> DATA_PULL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataPullMode").getter(getter(ScheduledTriggerProperties::dataPullModeAsString))
            .setter(setter(Builder::dataPullMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPullMode").build()).build();

    private static final SdkField<Instant> SCHEDULE_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("scheduleStartTime").getter(getter(ScheduledTriggerProperties::scheduleStartTime))
            .setter(setter(Builder::scheduleStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleStartTime").build()).build();

    private static final SdkField<Instant> SCHEDULE_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("scheduleEndTime").getter(getter(ScheduledTriggerProperties::scheduleEndTime))
            .setter(setter(Builder::scheduleEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleEndTime").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(ScheduledTriggerProperties::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final SdkField<Long> SCHEDULE_OFFSET_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("scheduleOffset").getter(getter(ScheduledTriggerProperties::scheduleOffset))
            .setter(setter(Builder::scheduleOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleOffset").build()).build();

    private static final SdkField<Instant> FIRST_EXECUTION_FROM_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("firstExecutionFrom").getter(getter(ScheduledTriggerProperties::firstExecutionFrom))
            .setter(setter(Builder::firstExecutionFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstExecutionFrom").build())
            .build();

    private static final SdkField<Integer> FLOW_ERROR_DEACTIVATION_THRESHOLD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("flowErrorDeactivationThreshold")
            .getter(getter(ScheduledTriggerProperties::flowErrorDeactivationThreshold))
            .setter(setter(Builder::flowErrorDeactivationThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowErrorDeactivationThreshold")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_EXPRESSION_FIELD,
            DATA_PULL_MODE_FIELD, SCHEDULE_START_TIME_FIELD, SCHEDULE_END_TIME_FIELD, TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD,
            FIRST_EXECUTION_FROM_FIELD, FLOW_ERROR_DEACTIVATION_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scheduleExpression;

    private final String dataPullMode;

    private final Instant scheduleStartTime;

    private final Instant scheduleEndTime;

    private final String timezone;

    private final Long scheduleOffset;

    private final Instant firstExecutionFrom;

    private final Integer flowErrorDeactivationThreshold;

    private ScheduledTriggerProperties(BuilderImpl builder) {
        this.scheduleExpression = builder.scheduleExpression;
        this.dataPullMode = builder.dataPullMode;
        this.scheduleStartTime = builder.scheduleStartTime;
        this.scheduleEndTime = builder.scheduleEndTime;
        this.timezone = builder.timezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.firstExecutionFrom = builder.firstExecutionFrom;
        this.flowErrorDeactivationThreshold = builder.flowErrorDeactivationThreshold;
    }

    /**
     * <p>
     * The scheduling expression that determines the rate at which the schedule will run, for example
     * <code>rate(5minutes)</code>.
     * </p>
     * 
     * @return The scheduling expression that determines the rate at which the schedule will run, for example
     *         <code>rate(5minutes)</code>.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow
     * run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPullMode} will
     * return {@link DataPullMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataPullModeAsString}.
     * </p>
     * 
     * @return Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each
     *         flow run.
     * @see DataPullMode
     */
    public final DataPullMode dataPullMode() {
        return DataPullMode.fromValue(dataPullMode);
    }

    /**
     * <p>
     * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow
     * run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataPullMode} will
     * return {@link DataPullMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataPullModeAsString}.
     * </p>
     * 
     * @return Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each
     *         flow run.
     * @see DataPullMode
     */
    public final String dataPullModeAsString() {
        return dataPullMode;
    }

    /**
     * <p>
     * The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO 8601
     * standard, such as <code>2022-04-26T13:00:00-07:00</code>.
     * </p>
     * 
     * @return The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO
     *         8601 standard, such as <code>2022-04-26T13:00:00-07:00</code>.
     */
    public final Instant scheduleStartTime() {
        return scheduleStartTime;
    }

    /**
     * <p>
     * The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO 8601
     * standard, such as <code>2022-04-27T13:00:00-07:00</code>.
     * </p>
     * 
     * @return The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO 8601
     *         standard, such as <code>2022-04-27T13:00:00-07:00</code>.
     */
    public final Instant scheduleEndTime() {
        return scheduleEndTime;
    }

    /**
     * <p>
     * Specifies the time zone used when referring to the dates and times of a scheduled flow, such as
     * <code>America/New_York</code>. This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow
     * interprets the timestamps that you specify to schedule the flow.
     * </p>
     * <p>
     * If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset
     * in your timestamps. For example, the UTC offsets for the <code>America/New_York</code> timezone are
     * <code>-04:00</code> EDT and <code>-05:00 EST</code>.
     * </p>
     * 
     * @return Specifies the time zone used when referring to the dates and times of a scheduled flow, such as
     *         <code>America/New_York</code>. This time zone is only a descriptive label. It doesn't affect how Amazon
     *         AppFlow interprets the timestamps that you specify to schedule the flow.</p>
     *         <p>
     *         If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC
     *         offset in your timestamps. For example, the UTC offsets for the <code>America/New_York</code> timezone
     *         are <code>-04:00</code> EDT and <code>-05:00 EST</code>.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
     * </p>
     * 
     * @return Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
     */
    public final Long scheduleOffset() {
        return scheduleOffset;
    }

    /**
     * <p>
     * Specifies the date range for the records to import from the connector in the first flow run.
     * </p>
     * 
     * @return Specifies the date range for the records to import from the connector in the first flow run.
     */
    public final Instant firstExecutionFrom() {
        return firstExecutionFrom;
    }

    /**
     * <p>
     * Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
     * </p>
     * 
     * @return Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
     */
    public final Integer flowErrorDeactivationThreshold() {
        return flowErrorDeactivationThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(dataPullModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(firstExecutionFrom());
        hashCode = 31 * hashCode + Objects.hashCode(flowErrorDeactivationThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledTriggerProperties)) {
            return false;
        }
        ScheduledTriggerProperties other = (ScheduledTriggerProperties) obj;
        return Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(dataPullModeAsString(), other.dataPullModeAsString())
                && Objects.equals(scheduleStartTime(), other.scheduleStartTime())
                && Objects.equals(scheduleEndTime(), other.scheduleEndTime()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(scheduleOffset(), other.scheduleOffset())
                && Objects.equals(firstExecutionFrom(), other.firstExecutionFrom())
                && Objects.equals(flowErrorDeactivationThreshold(), other.flowErrorDeactivationThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledTriggerProperties").add("ScheduleExpression", scheduleExpression())
                .add("DataPullMode", dataPullModeAsString()).add("ScheduleStartTime", scheduleStartTime())
                .add("ScheduleEndTime", scheduleEndTime()).add("Timezone", timezone()).add("ScheduleOffset", scheduleOffset())
                .add("FirstExecutionFrom", firstExecutionFrom())
                .add("FlowErrorDeactivationThreshold", flowErrorDeactivationThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "dataPullMode":
            return Optional.ofNullable(clazz.cast(dataPullModeAsString()));
        case "scheduleStartTime":
            return Optional.ofNullable(clazz.cast(scheduleStartTime()));
        case "scheduleEndTime":
            return Optional.ofNullable(clazz.cast(scheduleEndTime()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "scheduleOffset":
            return Optional.ofNullable(clazz.cast(scheduleOffset()));
        case "firstExecutionFrom":
            return Optional.ofNullable(clazz.cast(firstExecutionFrom()));
        case "flowErrorDeactivationThreshold":
            return Optional.ofNullable(clazz.cast(flowErrorDeactivationThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("dataPullMode", DATA_PULL_MODE_FIELD);
        map.put("scheduleStartTime", SCHEDULE_START_TIME_FIELD);
        map.put("scheduleEndTime", SCHEDULE_END_TIME_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("scheduleOffset", SCHEDULE_OFFSET_FIELD);
        map.put("firstExecutionFrom", FIRST_EXECUTION_FROM_FIELD);
        map.put("flowErrorDeactivationThreshold", FLOW_ERROR_DEACTIVATION_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledTriggerProperties, T> g) {
        return obj -> g.apply((ScheduledTriggerProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledTriggerProperties> {
        /**
         * <p>
         * The scheduling expression that determines the rate at which the schedule will run, for example
         * <code>rate(5minutes)</code>.
         * </p>
         * 
         * @param scheduleExpression
         *        The scheduling expression that determines the rate at which the schedule will run, for example
         *        <code>rate(5minutes)</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow
         * run.
         * </p>
         * 
         * @param dataPullMode
         *        Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for
         *        each flow run.
         * @see DataPullMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataPullMode
         */
        Builder dataPullMode(String dataPullMode);

        /**
         * <p>
         * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow
         * run.
         * </p>
         * 
         * @param dataPullMode
         *        Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for
         *        each flow run.
         * @see DataPullMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataPullMode
         */
        Builder dataPullMode(DataPullMode dataPullMode);

        /**
         * <p>
         * The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO 8601
         * standard, such as <code>2022-04-26T13:00:00-07:00</code>.
         * </p>
         * 
         * @param scheduleStartTime
         *        The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO
         *        8601 standard, such as <code>2022-04-26T13:00:00-07:00</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleStartTime(Instant scheduleStartTime);

        /**
         * <p>
         * The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO 8601
         * standard, such as <code>2022-04-27T13:00:00-07:00</code>.
         * </p>
         * 
         * @param scheduleEndTime
         *        The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO
         *        8601 standard, such as <code>2022-04-27T13:00:00-07:00</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleEndTime(Instant scheduleEndTime);

        /**
         * <p>
         * Specifies the time zone used when referring to the dates and times of a scheduled flow, such as
         * <code>America/New_York</code>. This time zone is only a descriptive label. It doesn't affect how Amazon
         * AppFlow interprets the timestamps that you specify to schedule the flow.
         * </p>
         * <p>
         * If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC
         * offset in your timestamps. For example, the UTC offsets for the <code>America/New_York</code> timezone are
         * <code>-04:00</code> EDT and <code>-05:00 EST</code>.
         * </p>
         * 
         * @param timezone
         *        Specifies the time zone used when referring to the dates and times of a scheduled flow, such as
         *        <code>America/New_York</code>. This time zone is only a descriptive label. It doesn't affect how
         *        Amazon AppFlow interprets the timestamps that you specify to schedule the flow.</p>
         *        <p>
         *        If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a
         *        UTC offset in your timestamps. For example, the UTC offsets for the <code>America/New_York</code>
         *        timezone are <code>-04:00</code> EDT and <code>-05:00 EST</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
         * </p>
         * 
         * @param scheduleOffset
         *        Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleOffset(Long scheduleOffset);

        /**
         * <p>
         * Specifies the date range for the records to import from the connector in the first flow run.
         * </p>
         * 
         * @param firstExecutionFrom
         *        Specifies the date range for the records to import from the connector in the first flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstExecutionFrom(Instant firstExecutionFrom);

        /**
         * <p>
         * Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
         * </p>
         * 
         * @param flowErrorDeactivationThreshold
         *        Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowErrorDeactivationThreshold(Integer flowErrorDeactivationThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String scheduleExpression;

        private String dataPullMode;

        private Instant scheduleStartTime;

        private Instant scheduleEndTime;

        private String timezone;

        private Long scheduleOffset;

        private Instant firstExecutionFrom;

        private Integer flowErrorDeactivationThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledTriggerProperties model) {
            scheduleExpression(model.scheduleExpression);
            dataPullMode(model.dataPullMode);
            scheduleStartTime(model.scheduleStartTime);
            scheduleEndTime(model.scheduleEndTime);
            timezone(model.timezone);
            scheduleOffset(model.scheduleOffset);
            firstExecutionFrom(model.firstExecutionFrom);
            flowErrorDeactivationThreshold(model.flowErrorDeactivationThreshold);
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getDataPullMode() {
            return dataPullMode;
        }

        public final void setDataPullMode(String dataPullMode) {
            this.dataPullMode = dataPullMode;
        }

        @Override
        public final Builder dataPullMode(String dataPullMode) {
            this.dataPullMode = dataPullMode;
            return this;
        }

        @Override
        public final Builder dataPullMode(DataPullMode dataPullMode) {
            this.dataPullMode(dataPullMode == null ? null : dataPullMode.toString());
            return this;
        }

        public final Instant getScheduleStartTime() {
            return scheduleStartTime;
        }

        public final void setScheduleStartTime(Instant scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
        }

        @Override
        public final Builder scheduleStartTime(Instant scheduleStartTime) {
            this.scheduleStartTime = scheduleStartTime;
            return this;
        }

        public final Instant getScheduleEndTime() {
            return scheduleEndTime;
        }

        public final void setScheduleEndTime(Instant scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
        }

        @Override
        public final Builder scheduleEndTime(Instant scheduleEndTime) {
            this.scheduleEndTime = scheduleEndTime;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Long getScheduleOffset() {
            return scheduleOffset;
        }

        public final void setScheduleOffset(Long scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Long scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final Instant getFirstExecutionFrom() {
            return firstExecutionFrom;
        }

        public final void setFirstExecutionFrom(Instant firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
        }

        @Override
        public final Builder firstExecutionFrom(Instant firstExecutionFrom) {
            this.firstExecutionFrom = firstExecutionFrom;
            return this;
        }

        public final Integer getFlowErrorDeactivationThreshold() {
            return flowErrorDeactivationThreshold;
        }

        public final void setFlowErrorDeactivationThreshold(Integer flowErrorDeactivationThreshold) {
            this.flowErrorDeactivationThreshold = flowErrorDeactivationThreshold;
        }

        @Override
        public final Builder flowErrorDeactivationThreshold(Integer flowErrorDeactivationThreshold) {
            this.flowErrorDeactivationThreshold = flowErrorDeactivationThreshold;
            return this;
        }

        @Override
        public ScheduledTriggerProperties build() {
            return new ScheduledTriggerProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
