/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration that Amazon AppFlow uses when it catalogs your data. When Amazon AppFlow catalogs your
 * data, it stores metadata in a data catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataCatalogConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataCatalogConfig.Builder, MetadataCatalogConfig> {
    private static final SdkField<GlueDataCatalogConfig> GLUE_DATA_CATALOG_FIELD = SdkField
            .<GlueDataCatalogConfig> builder(MarshallingType.SDK_POJO).memberName("glueDataCatalog")
            .getter(getter(MetadataCatalogConfig::glueDataCatalog)).setter(setter(Builder::glueDataCatalog))
            .constructor(GlueDataCatalogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueDataCatalog").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_DATA_CATALOG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GlueDataCatalogConfig glueDataCatalog;

    private MetadataCatalogConfig(BuilderImpl builder) {
        this.glueDataCatalog = builder.glueDataCatalog;
    }

    /**
     * <p>
     * Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the Glue Data Catalog.
     * </p>
     * 
     * @return Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the Glue Data
     *         Catalog.
     */
    public final GlueDataCatalogConfig glueDataCatalog() {
        return glueDataCatalog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueDataCatalog());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataCatalogConfig)) {
            return false;
        }
        MetadataCatalogConfig other = (MetadataCatalogConfig) obj;
        return Objects.equals(glueDataCatalog(), other.glueDataCatalog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataCatalogConfig").add("GlueDataCatalog", glueDataCatalog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glueDataCatalog":
            return Optional.ofNullable(clazz.cast(glueDataCatalog()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("glueDataCatalog", GLUE_DATA_CATALOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataCatalogConfig, T> g) {
        return obj -> g.apply((MetadataCatalogConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataCatalogConfig> {
        /**
         * <p>
         * Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the Glue Data Catalog.
         * </p>
         * 
         * @param glueDataCatalog
         *        Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the Glue Data
         *        Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueDataCatalog(GlueDataCatalogConfig glueDataCatalog);

        /**
         * <p>
         * Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the Glue Data Catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueDataCatalogConfig.Builder} avoiding
         * the need to create one manually via {@link GlueDataCatalogConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueDataCatalogConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #glueDataCatalog(GlueDataCatalogConfig)}.
         * 
         * @param glueDataCatalog
         *        a consumer that will call methods on {@link GlueDataCatalogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueDataCatalog(GlueDataCatalogConfig)
         */
        default Builder glueDataCatalog(Consumer<GlueDataCatalogConfig.Builder> glueDataCatalog) {
            return glueDataCatalog(GlueDataCatalogConfig.builder().applyMutation(glueDataCatalog).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueDataCatalogConfig glueDataCatalog;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataCatalogConfig model) {
            glueDataCatalog(model.glueDataCatalog);
        }

        public final GlueDataCatalogConfig.Builder getGlueDataCatalog() {
            return glueDataCatalog != null ? glueDataCatalog.toBuilder() : null;
        }

        public final void setGlueDataCatalog(GlueDataCatalogConfig.BuilderImpl glueDataCatalog) {
            this.glueDataCatalog = glueDataCatalog != null ? glueDataCatalog.build() : null;
        }

        @Override
        public final Builder glueDataCatalog(GlueDataCatalogConfig glueDataCatalog) {
            this.glueDataCatalog = glueDataCatalog;
            return this;
        }

        @Override
        public MetadataCatalogConfig build() {
            return new MetadataCatalogConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
