/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectorProvisioningConfig;
import software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterConnectorRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, RegisterConnectorRequest> {
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorLabel").getter(RegisterConnectorRequest.getter(RegisterConnectorRequest::connectorLabel)).setter(RegisterConnectorRequest.setter(Builder::connectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RegisterConnectorRequest.getter(RegisterConnectorRequest::description)).setter(RegisterConnectorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CONNECTOR_PROVISIONING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProvisioningType").getter(RegisterConnectorRequest.getter(RegisterConnectorRequest::connectorProvisioningTypeAsString)).setter(RegisterConnectorRequest.setter(Builder::connectorProvisioningType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningType").build()}).build();
    private static final SdkField<ConnectorProvisioningConfig> CONNECTOR_PROVISIONING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectorProvisioningConfig").getter(RegisterConnectorRequest.getter(RegisterConnectorRequest::connectorProvisioningConfig)).setter(RegisterConnectorRequest.setter(Builder::connectorProvisioningConfig)).constructor(ConnectorProvisioningConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningConfig").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(RegisterConnectorRequest.getter(RegisterConnectorRequest::clientToken)).setter(RegisterConnectorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_LABEL_FIELD, DESCRIPTION_FIELD, CONNECTOR_PROVISIONING_TYPE_FIELD, CONNECTOR_PROVISIONING_CONFIG_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterConnectorRequest.memberNameToFieldInitializer();
    private final String connectorLabel;
    private final String description;
    private final String connectorProvisioningType;
    private final ConnectorProvisioningConfig connectorProvisioningConfig;
    private final String clientToken;

    private RegisterConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.connectorLabel = builder.connectorLabel;
        this.description = builder.description;
        this.connectorProvisioningType = builder.connectorProvisioningType;
        this.connectorProvisioningConfig = builder.connectorProvisioningConfig;
        this.clientToken = builder.clientToken;
    }

    public final String connectorLabel() {
        return this.connectorLabel;
    }

    public final String description() {
        return this.description;
    }

    public final ConnectorProvisioningType connectorProvisioningType() {
        return ConnectorProvisioningType.fromValue(this.connectorProvisioningType);
    }

    public final String connectorProvisioningTypeAsString() {
        return this.connectorProvisioningType;
    }

    public final ConnectorProvisioningConfig connectorProvisioningConfig() {
        return this.connectorProvisioningConfig;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProvisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProvisioningConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterConnectorRequest)) {
            return false;
        }
        RegisterConnectorRequest other = (RegisterConnectorRequest)((Object)obj);
        return Objects.equals(this.connectorLabel(), other.connectorLabel()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.connectorProvisioningTypeAsString(), other.connectorProvisioningTypeAsString()) && Objects.equals(this.connectorProvisioningConfig(), other.connectorProvisioningConfig()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterConnectorRequest").add("ConnectorLabel", (Object)this.connectorLabel()).add("Description", (Object)this.description()).add("ConnectorProvisioningType", (Object)this.connectorProvisioningTypeAsString()).add("ConnectorProvisioningConfig", (Object)this.connectorProvisioningConfig()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorLabel": {
                return Optional.ofNullable(clazz.cast(this.connectorLabel()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "connectorProvisioningType": {
                return Optional.ofNullable(clazz.cast(this.connectorProvisioningTypeAsString()));
            }
            case "connectorProvisioningConfig": {
                return Optional.ofNullable(clazz.cast(this.connectorProvisioningConfig()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectorLabel", CONNECTOR_LABEL_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("connectorProvisioningType", CONNECTOR_PROVISIONING_TYPE_FIELD);
        map.put("connectorProvisioningConfig", CONNECTOR_PROVISIONING_CONFIG_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterConnectorRequest, T> g) {
        return obj -> g.apply((RegisterConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private String connectorLabel;
        private String description;
        private String connectorProvisioningType;
        private ConnectorProvisioningConfig connectorProvisioningConfig;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterConnectorRequest model) {
            super(model);
            this.connectorLabel(model.connectorLabel);
            this.description(model.description);
            this.connectorProvisioningType(model.connectorProvisioningType);
            this.connectorProvisioningConfig(model.connectorProvisioningConfig);
            this.clientToken(model.clientToken);
        }

        public final String getConnectorLabel() {
            return this.connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getConnectorProvisioningType() {
            return this.connectorProvisioningType;
        }

        public final void setConnectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
        }

        @Override
        public final Builder connectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
            return this;
        }

        @Override
        public final Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType) {
            this.connectorProvisioningType(connectorProvisioningType == null ? null : connectorProvisioningType.toString());
            return this;
        }

        public final ConnectorProvisioningConfig.Builder getConnectorProvisioningConfig() {
            return this.connectorProvisioningConfig != null ? this.connectorProvisioningConfig.toBuilder() : null;
        }

        public final void setConnectorProvisioningConfig(ConnectorProvisioningConfig.BuilderImpl connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig != null ? connectorProvisioningConfig.build() : null;
        }

        @Override
        public final Builder connectorProvisioningConfig(ConnectorProvisioningConfig connectorProvisioningConfig) {
            this.connectorProvisioningConfig = connectorProvisioningConfig;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterConnectorRequest build() {
            return new RegisterConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterConnectorRequest> {
        public Builder connectorLabel(String var1);

        public Builder description(String var1);

        public Builder connectorProvisioningType(String var1);

        public Builder connectorProvisioningType(ConnectorProvisioningType var1);

        public Builder connectorProvisioningConfig(ConnectorProvisioningConfig var1);

        default public Builder connectorProvisioningConfig(Consumer<ConnectorProvisioningConfig.Builder> connectorProvisioningConfig) {
            return this.connectorProvisioningConfig((ConnectorProvisioningConfig)((ConnectorProvisioningConfig.Builder)ConnectorProvisioningConfig.builder().applyMutation(connectorProvisioningConfig)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

