/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3InputFileType {
    CSV("CSV"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3InputFileType> VALUE_MAP;
    private final String value;

    private S3InputFileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3InputFileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3InputFileType> knownValues() {
        EnumSet<S3InputFileType> knownValues = EnumSet.allOf(S3InputFileType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3InputFileType.class, S3InputFileType::toString);
    }
}

