/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appflow.model.CustomPropertiesCopier;
import software.amazon.awssdk.services.appflow.model.DestinationFieldProperties;
import software.amazon.awssdk.services.appflow.model.SourceFieldProperties;
import software.amazon.awssdk.services.appflow.model.SupportedFieldTypeDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorEntityField
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorEntityField> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(ConnectorEntityField.getter(ConnectorEntityField::identifier)).setter(ConnectorEntityField.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> PARENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentIdentifier").getter(ConnectorEntityField.getter(ConnectorEntityField::parentIdentifier)).setter(ConnectorEntityField.setter(Builder::parentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIdentifier").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("label").getter(ConnectorEntityField.getter(ConnectorEntityField::label)).setter(ConnectorEntityField.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<Boolean> IS_PRIMARY_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPrimaryKey").getter(ConnectorEntityField.getter(ConnectorEntityField::isPrimaryKey)).setter(ConnectorEntityField.setter(Builder::isPrimaryKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrimaryKey").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(ConnectorEntityField.getter(ConnectorEntityField::defaultValue)).setter(ConnectorEntityField.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<Boolean> IS_DEPRECATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDeprecated").getter(ConnectorEntityField.getter(ConnectorEntityField::isDeprecated)).setter(ConnectorEntityField.setter(Builder::isDeprecated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDeprecated").build()}).build();
    private static final SdkField<SupportedFieldTypeDetails> SUPPORTED_FIELD_TYPE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("supportedFieldTypeDetails").getter(ConnectorEntityField.getter(ConnectorEntityField::supportedFieldTypeDetails)).setter(ConnectorEntityField.setter(Builder::supportedFieldTypeDetails)).constructor(SupportedFieldTypeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedFieldTypeDetails").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ConnectorEntityField.getter(ConnectorEntityField::description)).setter(ConnectorEntityField.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SourceFieldProperties> SOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceProperties").getter(ConnectorEntityField.getter(ConnectorEntityField::sourceProperties)).setter(ConnectorEntityField.setter(Builder::sourceProperties)).constructor(SourceFieldProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()}).build();
    private static final SdkField<DestinationFieldProperties> DESTINATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationProperties").getter(ConnectorEntityField.getter(ConnectorEntityField::destinationProperties)).setter(ConnectorEntityField.setter(Builder::destinationProperties)).constructor(DestinationFieldProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("customProperties").getter(ConnectorEntityField.getter(ConnectorEntityField::customProperties)).setter(ConnectorEntityField.setter(Builder::customProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, PARENT_IDENTIFIER_FIELD, LABEL_FIELD, IS_PRIMARY_KEY_FIELD, DEFAULT_VALUE_FIELD, IS_DEPRECATED_FIELD, SUPPORTED_FIELD_TYPE_DETAILS_FIELD, DESCRIPTION_FIELD, SOURCE_PROPERTIES_FIELD, DESTINATION_PROPERTIES_FIELD, CUSTOM_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectorEntityField.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String parentIdentifier;
    private final String label;
    private final Boolean isPrimaryKey;
    private final String defaultValue;
    private final Boolean isDeprecated;
    private final SupportedFieldTypeDetails supportedFieldTypeDetails;
    private final String description;
    private final SourceFieldProperties sourceProperties;
    private final DestinationFieldProperties destinationProperties;
    private final Map<String, String> customProperties;

    private ConnectorEntityField(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.parentIdentifier = builder.parentIdentifier;
        this.label = builder.label;
        this.isPrimaryKey = builder.isPrimaryKey;
        this.defaultValue = builder.defaultValue;
        this.isDeprecated = builder.isDeprecated;
        this.supportedFieldTypeDetails = builder.supportedFieldTypeDetails;
        this.description = builder.description;
        this.sourceProperties = builder.sourceProperties;
        this.destinationProperties = builder.destinationProperties;
        this.customProperties = builder.customProperties;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String parentIdentifier() {
        return this.parentIdentifier;
    }

    public final String label() {
        return this.label;
    }

    public final Boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final Boolean isDeprecated() {
        return this.isDeprecated;
    }

    public final SupportedFieldTypeDetails supportedFieldTypeDetails() {
        return this.supportedFieldTypeDetails;
    }

    public final String description() {
        return this.description;
    }

    public final SourceFieldProperties sourceProperties() {
        return this.sourceProperties;
    }

    public final DestinationFieldProperties destinationProperties() {
        return this.destinationProperties;
    }

    public final boolean hasCustomProperties() {
        return this.customProperties != null && !(this.customProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customProperties() {
        return this.customProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrimaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDeprecated());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedFieldTypeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomProperties() ? this.customProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorEntityField)) {
            return false;
        }
        ConnectorEntityField other = (ConnectorEntityField)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.parentIdentifier(), other.parentIdentifier()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.isPrimaryKey(), other.isPrimaryKey()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.isDeprecated(), other.isDeprecated()) && Objects.equals(this.supportedFieldTypeDetails(), other.supportedFieldTypeDetails()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.sourceProperties(), other.sourceProperties()) && Objects.equals(this.destinationProperties(), other.destinationProperties()) && this.hasCustomProperties() == other.hasCustomProperties() && Objects.equals(this.customProperties(), other.customProperties());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorEntityField").add("Identifier", (Object)this.identifier()).add("ParentIdentifier", (Object)this.parentIdentifier()).add("Label", (Object)this.label()).add("IsPrimaryKey", (Object)this.isPrimaryKey()).add("DefaultValue", (Object)this.defaultValue()).add("IsDeprecated", (Object)this.isDeprecated()).add("SupportedFieldTypeDetails", (Object)this.supportedFieldTypeDetails()).add("Description", (Object)this.description()).add("SourceProperties", (Object)this.sourceProperties()).add("DestinationProperties", (Object)this.destinationProperties()).add("CustomProperties", this.hasCustomProperties() ? this.customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "parentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.parentIdentifier()));
            }
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "isPrimaryKey": {
                return Optional.ofNullable(clazz.cast(this.isPrimaryKey()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "isDeprecated": {
                return Optional.ofNullable(clazz.cast(this.isDeprecated()));
            }
            case "supportedFieldTypeDetails": {
                return Optional.ofNullable(clazz.cast(this.supportedFieldTypeDetails()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sourceProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProperties()));
            }
            case "destinationProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationProperties()));
            }
            case "customProperties": {
                return Optional.ofNullable(clazz.cast(this.customProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("parentIdentifier", PARENT_IDENTIFIER_FIELD);
        map.put("label", LABEL_FIELD);
        map.put("isPrimaryKey", IS_PRIMARY_KEY_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("isDeprecated", IS_DEPRECATED_FIELD);
        map.put("supportedFieldTypeDetails", SUPPORTED_FIELD_TYPE_DETAILS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sourceProperties", SOURCE_PROPERTIES_FIELD);
        map.put("destinationProperties", DESTINATION_PROPERTIES_FIELD);
        map.put("customProperties", CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorEntityField, T> g) {
        return obj -> g.apply((ConnectorEntityField)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String parentIdentifier;
        private String label;
        private Boolean isPrimaryKey;
        private String defaultValue;
        private Boolean isDeprecated;
        private SupportedFieldTypeDetails supportedFieldTypeDetails;
        private String description;
        private SourceFieldProperties sourceProperties;
        private DestinationFieldProperties destinationProperties;
        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorEntityField model) {
            this.identifier(model.identifier);
            this.parentIdentifier(model.parentIdentifier);
            this.label(model.label);
            this.isPrimaryKey(model.isPrimaryKey);
            this.defaultValue(model.defaultValue);
            this.isDeprecated(model.isDeprecated);
            this.supportedFieldTypeDetails(model.supportedFieldTypeDetails);
            this.description(model.description);
            this.sourceProperties(model.sourceProperties);
            this.destinationProperties(model.destinationProperties);
            this.customProperties(model.customProperties);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getParentIdentifier() {
            return this.parentIdentifier;
        }

        public final void setParentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
        }

        @Override
        public final Builder parentIdentifier(String parentIdentifier) {
            this.parentIdentifier = parentIdentifier;
            return this;
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Boolean getIsPrimaryKey() {
            return this.isPrimaryKey;
        }

        public final void setIsPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }

        @Override
        public final Builder isPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Boolean getIsDeprecated() {
            return this.isDeprecated;
        }

        public final void setIsDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
        }

        @Override
        public final Builder isDeprecated(Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        public final SupportedFieldTypeDetails.Builder getSupportedFieldTypeDetails() {
            return this.supportedFieldTypeDetails != null ? this.supportedFieldTypeDetails.toBuilder() : null;
        }

        public final void setSupportedFieldTypeDetails(SupportedFieldTypeDetails.BuilderImpl supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails != null ? supportedFieldTypeDetails.build() : null;
        }

        @Override
        public final Builder supportedFieldTypeDetails(SupportedFieldTypeDetails supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SourceFieldProperties.Builder getSourceProperties() {
            return this.sourceProperties != null ? this.sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceFieldProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        public final Builder sourceProperties(SourceFieldProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final DestinationFieldProperties.Builder getDestinationProperties() {
            return this.destinationProperties != null ? this.destinationProperties.toBuilder() : null;
        }

        public final void setDestinationProperties(DestinationFieldProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationFieldProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (this.customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        public ConnectorEntityField build() {
            return new ConnectorEntityField(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorEntityField> {
        public Builder identifier(String var1);

        public Builder parentIdentifier(String var1);

        public Builder label(String var1);

        public Builder isPrimaryKey(Boolean var1);

        public Builder defaultValue(String var1);

        public Builder isDeprecated(Boolean var1);

        public Builder supportedFieldTypeDetails(SupportedFieldTypeDetails var1);

        default public Builder supportedFieldTypeDetails(Consumer<SupportedFieldTypeDetails.Builder> supportedFieldTypeDetails) {
            return this.supportedFieldTypeDetails((SupportedFieldTypeDetails)((SupportedFieldTypeDetails.Builder)SupportedFieldTypeDetails.builder().applyMutation(supportedFieldTypeDetails)).build());
        }

        public Builder description(String var1);

        public Builder sourceProperties(SourceFieldProperties var1);

        default public Builder sourceProperties(Consumer<SourceFieldProperties.Builder> sourceProperties) {
            return this.sourceProperties((SourceFieldProperties)((SourceFieldProperties.Builder)SourceFieldProperties.builder().applyMutation(sourceProperties)).build());
        }

        public Builder destinationProperties(DestinationFieldProperties var1);

        default public Builder destinationProperties(Consumer<DestinationFieldProperties.Builder> destinationProperties) {
            return this.destinationProperties((DestinationFieldProperties)((DestinationFieldProperties.Builder)DestinationFieldProperties.builder().applyMutation(destinationProperties)).build());
        }

        public Builder customProperties(Map<String, String> var1);
    }
}

