/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.AppflowRequest;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.ConnectorTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectorsRequest
extends AppflowRequest
implements ToCopyableBuilder<Builder, DescribeConnectorsRequest> {
    private static final SdkField<List<String>> CONNECTOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorTypes").getter(DescribeConnectorsRequest.getter(DescribeConnectorsRequest::connectorTypesAsStrings)).setter(DescribeConnectorsRequest.setter(Builder::connectorTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(DescribeConnectorsRequest.getter(DescribeConnectorsRequest::maxResults)).setter(DescribeConnectorsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeConnectorsRequest.getter(DescribeConnectorsRequest::nextToken)).setter(DescribeConnectorsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_TYPES_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("connectorTypes", CONNECTOR_TYPES_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> connectorTypes;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeConnectorsRequest(BuilderImpl builder) {
        super(builder);
        this.connectorTypes = builder.connectorTypes;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final List<ConnectorType> connectorTypes() {
        return ConnectorTypeListCopier.copyStringToEnum(this.connectorTypes);
    }

    public final boolean hasConnectorTypes() {
        return this.connectorTypes != null && !(this.connectorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> connectorTypesAsStrings() {
        return this.connectorTypes;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorTypes() ? this.connectorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorsRequest)) {
            return false;
        }
        DescribeConnectorsRequest other = (DescribeConnectorsRequest)((Object)obj);
        return this.hasConnectorTypes() == other.hasConnectorTypes() && Objects.equals(this.connectorTypesAsStrings(), other.connectorTypesAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectorsRequest").add("ConnectorTypes", this.hasConnectorTypes() ? this.connectorTypesAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorTypes": {
                return Optional.ofNullable(clazz.cast(this.connectorTypesAsStrings()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorsRequest, T> g) {
        return obj -> g.apply((DescribeConnectorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppflowRequest.BuilderImpl
    implements Builder {
        private List<String> connectorTypes = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorsRequest model) {
            super(model);
            this.connectorTypesWithStrings(model.connectorTypes);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getConnectorTypes() {
            if (this.connectorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorTypes;
        }

        public final void setConnectorTypes(Collection<String> connectorTypes) {
            this.connectorTypes = ConnectorTypeListCopier.copy(connectorTypes);
        }

        @Override
        public final Builder connectorTypesWithStrings(Collection<String> connectorTypes) {
            this.connectorTypes = ConnectorTypeListCopier.copy(connectorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorTypesWithStrings(String ... connectorTypes) {
            this.connectorTypesWithStrings(Arrays.asList(connectorTypes));
            return this;
        }

        @Override
        public final Builder connectorTypes(Collection<ConnectorType> connectorTypes) {
            this.connectorTypes = ConnectorTypeListCopier.copyEnumToString(connectorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorTypes(ConnectorType ... connectorTypes) {
            this.connectorTypes(Arrays.asList(connectorTypes));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConnectorsRequest build() {
            return new DescribeConnectorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppflowRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConnectorsRequest> {
        public Builder connectorTypesWithStrings(Collection<String> var1);

        public Builder connectorTypesWithStrings(String ... var1);

        public Builder connectorTypes(Collection<ConnectorType> var1);

        public Builder connectorTypes(ConnectorType ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

