/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.ConnectorModeListCopier;
import software.amazon.awssdk.services.appflow.model.ConnectorProvisioningType;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.SupportedDataTransferType;
import software.amazon.awssdk.services.appflow.model.SupportedDataTransferTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorDetail> {
    private static final SdkField<String> CONNECTOR_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorDescription").getter(ConnectorDetail.getter(ConnectorDetail::connectorDescription)).setter(ConnectorDetail.setter(Builder::connectorDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorDescription").build()}).build();
    private static final SdkField<String> CONNECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorName").getter(ConnectorDetail.getter(ConnectorDetail::connectorName)).setter(ConnectorDetail.setter(Builder::connectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorName").build()}).build();
    private static final SdkField<String> CONNECTOR_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOwner").getter(ConnectorDetail.getter(ConnectorDetail::connectorOwner)).setter(ConnectorDetail.setter(Builder::connectorOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOwner").build()}).build();
    private static final SdkField<String> CONNECTOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorVersion").getter(ConnectorDetail.getter(ConnectorDetail::connectorVersion)).setter(ConnectorDetail.setter(Builder::connectorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorVersion").build()}).build();
    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationType").getter(ConnectorDetail.getter(ConnectorDetail::applicationType)).setter(ConnectorDetail.setter(Builder::applicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationType").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorType").getter(ConnectorDetail.getter(ConnectorDetail::connectorTypeAsString)).setter(ConnectorDetail.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorType").build()}).build();
    private static final SdkField<String> CONNECTOR_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorLabel").getter(ConnectorDetail.getter(ConnectorDetail::connectorLabel)).setter(ConnectorDetail.setter(Builder::connectorLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorLabel").build()}).build();
    private static final SdkField<Instant> REGISTERED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("registeredAt").getter(ConnectorDetail.getter(ConnectorDetail::registeredAt)).setter(ConnectorDetail.setter(Builder::registeredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredAt").build()}).build();
    private static final SdkField<String> REGISTERED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registeredBy").getter(ConnectorDetail.getter(ConnectorDetail::registeredBy)).setter(ConnectorDetail.setter(Builder::registeredBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredBy").build()}).build();
    private static final SdkField<String> CONNECTOR_PROVISIONING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorProvisioningType").getter(ConnectorDetail.getter(ConnectorDetail::connectorProvisioningTypeAsString)).setter(ConnectorDetail.setter(Builder::connectorProvisioningType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorProvisioningType").build()}).build();
    private static final SdkField<List<String>> CONNECTOR_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connectorModes").getter(ConnectorDetail.getter(ConnectorDetail::connectorModes)).setter(ConnectorDetail.setter(Builder::connectorModes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_DATA_TRANSFER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedDataTransferTypes").getter(ConnectorDetail.getter(ConnectorDetail::supportedDataTransferTypesAsStrings)).setter(ConnectorDetail.setter(Builder::supportedDataTransferTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDataTransferTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_DESCRIPTION_FIELD, CONNECTOR_NAME_FIELD, CONNECTOR_OWNER_FIELD, CONNECTOR_VERSION_FIELD, APPLICATION_TYPE_FIELD, CONNECTOR_TYPE_FIELD, CONNECTOR_LABEL_FIELD, REGISTERED_AT_FIELD, REGISTERED_BY_FIELD, CONNECTOR_PROVISIONING_TYPE_FIELD, CONNECTOR_MODES_FIELD, SUPPORTED_DATA_TRANSFER_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectorDescription;
    private final String connectorName;
    private final String connectorOwner;
    private final String connectorVersion;
    private final String applicationType;
    private final String connectorType;
    private final String connectorLabel;
    private final Instant registeredAt;
    private final String registeredBy;
    private final String connectorProvisioningType;
    private final List<String> connectorModes;
    private final List<String> supportedDataTransferTypes;

    private ConnectorDetail(BuilderImpl builder) {
        this.connectorDescription = builder.connectorDescription;
        this.connectorName = builder.connectorName;
        this.connectorOwner = builder.connectorOwner;
        this.connectorVersion = builder.connectorVersion;
        this.applicationType = builder.applicationType;
        this.connectorType = builder.connectorType;
        this.connectorLabel = builder.connectorLabel;
        this.registeredAt = builder.registeredAt;
        this.registeredBy = builder.registeredBy;
        this.connectorProvisioningType = builder.connectorProvisioningType;
        this.connectorModes = builder.connectorModes;
        this.supportedDataTransferTypes = builder.supportedDataTransferTypes;
    }

    public final String connectorDescription() {
        return this.connectorDescription;
    }

    public final String connectorName() {
        return this.connectorName;
    }

    public final String connectorOwner() {
        return this.connectorOwner;
    }

    public final String connectorVersion() {
        return this.connectorVersion;
    }

    public final String applicationType() {
        return this.applicationType;
    }

    public final ConnectorType connectorType() {
        return ConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final String connectorLabel() {
        return this.connectorLabel;
    }

    public final Instant registeredAt() {
        return this.registeredAt;
    }

    public final String registeredBy() {
        return this.registeredBy;
    }

    public final ConnectorProvisioningType connectorProvisioningType() {
        return ConnectorProvisioningType.fromValue(this.connectorProvisioningType);
    }

    public final String connectorProvisioningTypeAsString() {
        return this.connectorProvisioningType;
    }

    public final boolean hasConnectorModes() {
        return this.connectorModes != null && !(this.connectorModes instanceof SdkAutoConstructList);
    }

    public final List<String> connectorModes() {
        return this.connectorModes;
    }

    public final List<SupportedDataTransferType> supportedDataTransferTypes() {
        return SupportedDataTransferTypeListCopier.copyStringToEnum(this.supportedDataTransferTypes);
    }

    public final boolean hasSupportedDataTransferTypes() {
        return this.supportedDataTransferTypes != null && !(this.supportedDataTransferTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedDataTransferTypesAsStrings() {
        return this.supportedDataTransferTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProvisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectorModes() ? this.connectorModes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedDataTransferTypes() ? this.supportedDataTransferTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorDetail)) {
            return false;
        }
        ConnectorDetail other = (ConnectorDetail)obj;
        return Objects.equals(this.connectorDescription(), other.connectorDescription()) && Objects.equals(this.connectorName(), other.connectorName()) && Objects.equals(this.connectorOwner(), other.connectorOwner()) && Objects.equals(this.connectorVersion(), other.connectorVersion()) && Objects.equals(this.applicationType(), other.applicationType()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.connectorLabel(), other.connectorLabel()) && Objects.equals(this.registeredAt(), other.registeredAt()) && Objects.equals(this.registeredBy(), other.registeredBy()) && Objects.equals(this.connectorProvisioningTypeAsString(), other.connectorProvisioningTypeAsString()) && this.hasConnectorModes() == other.hasConnectorModes() && Objects.equals(this.connectorModes(), other.connectorModes()) && this.hasSupportedDataTransferTypes() == other.hasSupportedDataTransferTypes() && Objects.equals(this.supportedDataTransferTypesAsStrings(), other.supportedDataTransferTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorDetail").add("ConnectorDescription", (Object)this.connectorDescription()).add("ConnectorName", (Object)this.connectorName()).add("ConnectorOwner", (Object)this.connectorOwner()).add("ConnectorVersion", (Object)this.connectorVersion()).add("ApplicationType", (Object)this.applicationType()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("ConnectorLabel", (Object)this.connectorLabel()).add("RegisteredAt", (Object)this.registeredAt()).add("RegisteredBy", (Object)this.registeredBy()).add("ConnectorProvisioningType", (Object)this.connectorProvisioningTypeAsString()).add("ConnectorModes", this.hasConnectorModes() ? this.connectorModes() : null).add("SupportedDataTransferTypes", this.hasSupportedDataTransferTypes() ? this.supportedDataTransferTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorDescription": {
                return Optional.ofNullable(clazz.cast(this.connectorDescription()));
            }
            case "connectorName": {
                return Optional.ofNullable(clazz.cast(this.connectorName()));
            }
            case "connectorOwner": {
                return Optional.ofNullable(clazz.cast(this.connectorOwner()));
            }
            case "connectorVersion": {
                return Optional.ofNullable(clazz.cast(this.connectorVersion()));
            }
            case "applicationType": {
                return Optional.ofNullable(clazz.cast(this.applicationType()));
            }
            case "connectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "connectorLabel": {
                return Optional.ofNullable(clazz.cast(this.connectorLabel()));
            }
            case "registeredAt": {
                return Optional.ofNullable(clazz.cast(this.registeredAt()));
            }
            case "registeredBy": {
                return Optional.ofNullable(clazz.cast(this.registeredBy()));
            }
            case "connectorProvisioningType": {
                return Optional.ofNullable(clazz.cast(this.connectorProvisioningTypeAsString()));
            }
            case "connectorModes": {
                return Optional.ofNullable(clazz.cast(this.connectorModes()));
            }
            case "supportedDataTransferTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedDataTransferTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorDetail, T> g) {
        return obj -> g.apply((ConnectorDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorDescription;
        private String connectorName;
        private String connectorOwner;
        private String connectorVersion;
        private String applicationType;
        private String connectorType;
        private String connectorLabel;
        private Instant registeredAt;
        private String registeredBy;
        private String connectorProvisioningType;
        private List<String> connectorModes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedDataTransferTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorDetail model) {
            this.connectorDescription(model.connectorDescription);
            this.connectorName(model.connectorName);
            this.connectorOwner(model.connectorOwner);
            this.connectorVersion(model.connectorVersion);
            this.applicationType(model.applicationType);
            this.connectorType(model.connectorType);
            this.connectorLabel(model.connectorLabel);
            this.registeredAt(model.registeredAt);
            this.registeredBy(model.registeredBy);
            this.connectorProvisioningType(model.connectorProvisioningType);
            this.connectorModes(model.connectorModes);
            this.supportedDataTransferTypesWithStrings(model.supportedDataTransferTypes);
        }

        public final String getConnectorDescription() {
            return this.connectorDescription;
        }

        public final void setConnectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
        }

        @Override
        public final Builder connectorDescription(String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        public final String getConnectorName() {
            return this.connectorName;
        }

        public final void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @Override
        public final Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        public final String getConnectorOwner() {
            return this.connectorOwner;
        }

        public final void setConnectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
        }

        @Override
        public final Builder connectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
            return this;
        }

        public final String getConnectorVersion() {
            return this.connectorVersion;
        }

        public final void setConnectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
        }

        @Override
        public final Builder connectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
            return this;
        }

        public final String getApplicationType() {
            return this.applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(ConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final String getConnectorLabel() {
            return this.connectorLabel;
        }

        public final void setConnectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
        }

        @Override
        public final Builder connectorLabel(String connectorLabel) {
            this.connectorLabel = connectorLabel;
            return this;
        }

        public final Instant getRegisteredAt() {
            return this.registeredAt;
        }

        public final void setRegisteredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public final Builder registeredAt(Instant registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final String getRegisteredBy() {
            return this.registeredBy;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final String getConnectorProvisioningType() {
            return this.connectorProvisioningType;
        }

        public final void setConnectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
        }

        @Override
        public final Builder connectorProvisioningType(String connectorProvisioningType) {
            this.connectorProvisioningType = connectorProvisioningType;
            return this;
        }

        @Override
        public final Builder connectorProvisioningType(ConnectorProvisioningType connectorProvisioningType) {
            this.connectorProvisioningType(connectorProvisioningType == null ? null : connectorProvisioningType.toString());
            return this;
        }

        public final Collection<String> getConnectorModes() {
            if (this.connectorModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectorModes;
        }

        public final void setConnectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
        }

        @Override
        public final Builder connectorModes(Collection<String> connectorModes) {
            this.connectorModes = ConnectorModeListCopier.copy(connectorModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectorModes(String ... connectorModes) {
            this.connectorModes(Arrays.asList(connectorModes));
            return this;
        }

        public final Collection<String> getSupportedDataTransferTypes() {
            if (this.supportedDataTransferTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedDataTransferTypes;
        }

        public final void setSupportedDataTransferTypes(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
        }

        @Override
        public final Builder supportedDataTransferTypesWithStrings(Collection<String> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copy(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypesWithStrings(String ... supportedDataTransferTypes) {
            this.supportedDataTransferTypesWithStrings(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        @Override
        public final Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> supportedDataTransferTypes) {
            this.supportedDataTransferTypes = SupportedDataTransferTypeListCopier.copyEnumToString(supportedDataTransferTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDataTransferTypes(SupportedDataTransferType ... supportedDataTransferTypes) {
            this.supportedDataTransferTypes(Arrays.asList(supportedDataTransferTypes));
            return this;
        }

        public ConnectorDetail build() {
            return new ConnectorDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorDetail> {
        public Builder connectorDescription(String var1);

        public Builder connectorName(String var1);

        public Builder connectorOwner(String var1);

        public Builder connectorVersion(String var1);

        public Builder applicationType(String var1);

        public Builder connectorType(String var1);

        public Builder connectorType(ConnectorType var1);

        public Builder connectorLabel(String var1);

        public Builder registeredAt(Instant var1);

        public Builder registeredBy(String var1);

        public Builder connectorProvisioningType(String var1);

        public Builder connectorProvisioningType(ConnectorProvisioningType var1);

        public Builder connectorModes(Collection<String> var1);

        public Builder connectorModes(String ... var1);

        public Builder supportedDataTransferTypesWithStrings(Collection<String> var1);

        public Builder supportedDataTransferTypesWithStrings(String ... var1);

        public Builder supportedDataTransferTypes(Collection<SupportedDataTransferType> var1);

        public Builder supportedDataTransferTypes(SupportedDataTransferType ... var1);
    }
}

