/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ConnectorConfigurationsMapCopier {
    static Map<String, ConnectorConfiguration> copy(Map<String, ? extends ConnectorConfiguration> connectorConfigurationsMapParam) {
        Map<String, ConnectorConfiguration> map;
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ConnectorConfiguration> modifiableMap = new LinkedHashMap<>();
            connectorConfigurationsMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ConnectorConfiguration> copyFromBuilder(
            Map<String, ? extends ConnectorConfiguration.Builder> connectorConfigurationsMapParam) {
        Map<String, ConnectorConfiguration> map;
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ConnectorConfiguration> modifiableMap = new LinkedHashMap<>();
            connectorConfigurationsMapParam.forEach((key, value) -> {
                ConnectorConfiguration member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ConnectorConfiguration.Builder> copyToBuilder(
            Map<String, ? extends ConnectorConfiguration> connectorConfigurationsMapParam) {
        Map<String, ConnectorConfiguration.Builder> map;
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ConnectorConfiguration.Builder> modifiableMap = new LinkedHashMap<>();
            connectorConfigurationsMapParam.forEach((key, value) -> {
                ConnectorConfiguration.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ConnectorConfiguration> copyEnumToString(
            Map<ConnectorType, ? extends ConnectorConfiguration> connectorConfigurationsMapParam) {
        Map<String, ConnectorConfiguration> map;
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ConnectorConfiguration> modifiableMap = new LinkedHashMap<>();
            connectorConfigurationsMapParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<ConnectorType, ConnectorConfiguration> copyStringToEnum(
            Map<String, ? extends ConnectorConfiguration> connectorConfigurationsMapParam) {
        Map<ConnectorType, ConnectorConfiguration> map;
        if (connectorConfigurationsMapParam == null || connectorConfigurationsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<ConnectorType, ConnectorConfiguration> modifiableMap = new LinkedHashMap<>();
            connectorConfigurationsMapParam.forEach((key, value) -> {
                ConnectorType result = ConnectorType.fromValue(key);
                if (result != ConnectorType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
