/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ConnectorOAuthRequest;
import software.amazon.awssdk.services.appflow.model.OAuth2GrantType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceConnectorProfileCredentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessToken").getter(SalesforceConnectorProfileCredentials.getter(SalesforceConnectorProfileCredentials::accessToken)).setter(SalesforceConnectorProfileCredentials.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("refreshToken").getter(SalesforceConnectorProfileCredentials.getter(SalesforceConnectorProfileCredentials::refreshToken)).setter(SalesforceConnectorProfileCredentials.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final SdkField<ConnectorOAuthRequest> O_AUTH_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oAuthRequest").getter(SalesforceConnectorProfileCredentials.getter(SalesforceConnectorProfileCredentials::oAuthRequest)).setter(SalesforceConnectorProfileCredentials.setter(Builder::oAuthRequest)).constructor(ConnectorOAuthRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthRequest").build()}).build();
    private static final SdkField<String> CLIENT_CREDENTIALS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientCredentialsArn").getter(SalesforceConnectorProfileCredentials.getter(SalesforceConnectorProfileCredentials::clientCredentialsArn)).setter(SalesforceConnectorProfileCredentials.setter(Builder::clientCredentialsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCredentialsArn").build()}).build();
    private static final SdkField<String> O_AUTH2_GRANT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("oAuth2GrantType").getter(SalesforceConnectorProfileCredentials.getter(SalesforceConnectorProfileCredentials::oAuth2GrantTypeAsString)).setter(SalesforceConnectorProfileCredentials.setter(Builder::oAuth2GrantType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth2GrantType").build()}).build();
    private static final SdkField<String> JWT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jwtToken").getter(SalesforceConnectorProfileCredentials.getter(SalesforceConnectorProfileCredentials::jwtToken)).setter(SalesforceConnectorProfileCredentials.setter(Builder::jwtToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jwtToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, REFRESH_TOKEN_FIELD, O_AUTH_REQUEST_FIELD, CLIENT_CREDENTIALS_ARN_FIELD, O_AUTH2_GRANT_TYPE_FIELD, JWT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessToken;
    private final String refreshToken;
    private final ConnectorOAuthRequest oAuthRequest;
    private final String clientCredentialsArn;
    private final String oAuth2GrantType;
    private final String jwtToken;

    private SalesforceConnectorProfileCredentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.refreshToken = builder.refreshToken;
        this.oAuthRequest = builder.oAuthRequest;
        this.clientCredentialsArn = builder.clientCredentialsArn;
        this.oAuth2GrantType = builder.oAuth2GrantType;
        this.jwtToken = builder.jwtToken;
    }

    public final String accessToken() {
        return this.accessToken;
    }

    public final String refreshToken() {
        return this.refreshToken;
    }

    public final ConnectorOAuthRequest oAuthRequest() {
        return this.oAuthRequest;
    }

    public final String clientCredentialsArn() {
        return this.clientCredentialsArn;
    }

    public final OAuth2GrantType oAuth2GrantType() {
        return OAuth2GrantType.fromValue(this.oAuth2GrantType);
    }

    public final String oAuth2GrantTypeAsString() {
        return this.oAuth2GrantType;
    }

    public final String jwtToken() {
        return this.jwtToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthRequest());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCredentialsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth2GrantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jwtToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceConnectorProfileCredentials)) {
            return false;
        }
        SalesforceConnectorProfileCredentials other = (SalesforceConnectorProfileCredentials)obj;
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.oAuthRequest(), other.oAuthRequest()) && Objects.equals(this.clientCredentialsArn(), other.clientCredentialsArn()) && Objects.equals(this.oAuth2GrantTypeAsString(), other.oAuth2GrantTypeAsString()) && Objects.equals(this.jwtToken(), other.jwtToken());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceConnectorProfileCredentials").add("AccessToken", (Object)(this.accessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("RefreshToken", (Object)this.refreshToken()).add("OAuthRequest", (Object)this.oAuthRequest()).add("ClientCredentialsArn", (Object)(this.clientCredentialsArn() == null ? null : "*** Sensitive Data Redacted ***")).add("OAuth2GrantType", (Object)this.oAuth2GrantTypeAsString()).add("JwtToken", (Object)(this.jwtToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "oAuthRequest": {
                return Optional.ofNullable(clazz.cast(this.oAuthRequest()));
            }
            case "clientCredentialsArn": {
                return Optional.ofNullable(clazz.cast(this.clientCredentialsArn()));
            }
            case "oAuth2GrantType": {
                return Optional.ofNullable(clazz.cast(this.oAuth2GrantTypeAsString()));
            }
            case "jwtToken": {
                return Optional.ofNullable(clazz.cast(this.jwtToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceConnectorProfileCredentials, T> g) {
        return obj -> g.apply((SalesforceConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessToken;
        private String refreshToken;
        private ConnectorOAuthRequest oAuthRequest;
        private String clientCredentialsArn;
        private String oAuth2GrantType;
        private String jwtToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceConnectorProfileCredentials model) {
            this.accessToken(model.accessToken);
            this.refreshToken(model.refreshToken);
            this.oAuthRequest(model.oAuthRequest);
            this.clientCredentialsArn(model.clientCredentialsArn);
            this.oAuth2GrantType(model.oAuth2GrantType);
            this.jwtToken(model.jwtToken);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final ConnectorOAuthRequest.Builder getOAuthRequest() {
            return this.oAuthRequest != null ? this.oAuthRequest.toBuilder() : null;
        }

        public final void setOAuthRequest(ConnectorOAuthRequest.BuilderImpl oAuthRequest) {
            this.oAuthRequest = oAuthRequest != null ? oAuthRequest.build() : null;
        }

        @Override
        public final Builder oAuthRequest(ConnectorOAuthRequest oAuthRequest) {
            this.oAuthRequest = oAuthRequest;
            return this;
        }

        public final String getClientCredentialsArn() {
            return this.clientCredentialsArn;
        }

        public final void setClientCredentialsArn(String clientCredentialsArn) {
            this.clientCredentialsArn = clientCredentialsArn;
        }

        @Override
        public final Builder clientCredentialsArn(String clientCredentialsArn) {
            this.clientCredentialsArn = clientCredentialsArn;
            return this;
        }

        public final String getOAuth2GrantType() {
            return this.oAuth2GrantType;
        }

        public final void setOAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
        }

        @Override
        public final Builder oAuth2GrantType(String oAuth2GrantType) {
            this.oAuth2GrantType = oAuth2GrantType;
            return this;
        }

        @Override
        public final Builder oAuth2GrantType(OAuth2GrantType oAuth2GrantType) {
            this.oAuth2GrantType(oAuth2GrantType == null ? null : oAuth2GrantType.toString());
            return this;
        }

        public final String getJwtToken() {
            return this.jwtToken;
        }

        public final void setJwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
        }

        @Override
        public final Builder jwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
            return this;
        }

        public SalesforceConnectorProfileCredentials build() {
            return new SalesforceConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceConnectorProfileCredentials> {
        public Builder accessToken(String var1);

        public Builder refreshToken(String var1);

        public Builder oAuthRequest(ConnectorOAuthRequest var1);

        default public Builder oAuthRequest(Consumer<ConnectorOAuthRequest.Builder> oAuthRequest) {
            return this.oAuthRequest((ConnectorOAuthRequest)((ConnectorOAuthRequest.Builder)ConnectorOAuthRequest.builder().applyMutation(oAuthRequest)).build());
        }

        public Builder clientCredentialsArn(String var1);

        public Builder oAuth2GrantType(String var1);

        public Builder oAuth2GrantType(OAuth2GrantType var1);

        public Builder jwtToken(String var1);
    }
}

