/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PathPrefix {
    EXECUTION_ID("EXECUTION_ID"),
    SCHEMA_VERSION("SCHEMA_VERSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PathPrefix> VALUE_MAP;
    private final String value;

    private PathPrefix(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PathPrefix fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PathPrefix> knownValues() {
        EnumSet<PathPrefix> knownValues = EnumSet.allOf(PathPrefix.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PathPrefix.class, PathPrefix::toString);
    }
}

