/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatadogConnectorProfileCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatadogConnectorProfileCredentials> {
    private static final SdkField<String> API_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiKey").getter(DatadogConnectorProfileCredentials.getter(DatadogConnectorProfileCredentials::apiKey)).setter(DatadogConnectorProfileCredentials.setter(Builder::apiKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKey").build()}).build();
    private static final SdkField<String> APPLICATION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationKey").getter(DatadogConnectorProfileCredentials.getter(DatadogConnectorProfileCredentials::applicationKey)).setter(DatadogConnectorProfileCredentials.setter(Builder::applicationKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEY_FIELD, APPLICATION_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String apiKey;
    private final String applicationKey;

    private DatadogConnectorProfileCredentials(BuilderImpl builder) {
        this.apiKey = builder.apiKey;
        this.applicationKey = builder.applicationKey;
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String applicationKey() {
        return this.applicationKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatadogConnectorProfileCredentials)) {
            return false;
        }
        DatadogConnectorProfileCredentials other = (DatadogConnectorProfileCredentials)obj;
        return Objects.equals(this.apiKey(), other.apiKey()) && Objects.equals(this.applicationKey(), other.applicationKey());
    }

    public final String toString() {
        return ToString.builder((String)"DatadogConnectorProfileCredentials").add("ApiKey", (Object)this.apiKey()).add("ApplicationKey", (Object)this.applicationKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "apiKey": {
                return Optional.ofNullable(clazz.cast(this.apiKey()));
            }
            case "applicationKey": {
                return Optional.ofNullable(clazz.cast(this.applicationKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatadogConnectorProfileCredentials, T> g) {
        return obj -> g.apply((DatadogConnectorProfileCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String apiKey;
        private String applicationKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DatadogConnectorProfileCredentials model) {
            this.apiKey(model.apiKey);
            this.applicationKey(model.applicationKey);
        }

        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @Override
        @Transient
        public final Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public final String getApplicationKey() {
            return this.applicationKey;
        }

        public final void setApplicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
        }

        @Override
        @Transient
        public final Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            return this;
        }

        public DatadogConnectorProfileCredentials build() {
            return new DatadogConnectorProfileCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatadogConnectorProfileCredentials> {
        public Builder apiKey(String var1);

        public Builder applicationKey(String var1);
    }
}

