/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.ExecutionResult;
import software.amazon.awssdk.services.appflow.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionRecord> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(ExecutionRecord.getter(ExecutionRecord::executionId)).setter(ExecutionRecord.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(ExecutionRecord.getter(ExecutionRecord::executionStatusAsString)).setter(ExecutionRecord.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<ExecutionResult> EXECUTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionResult").getter(ExecutionRecord.getter(ExecutionRecord::executionResult)).setter(ExecutionRecord.setter(Builder::executionResult)).constructor(ExecutionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(ExecutionRecord.getter(ExecutionRecord::startedAt)).setter(ExecutionRecord.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(ExecutionRecord.getter(ExecutionRecord::lastUpdatedAt)).setter(ExecutionRecord.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<Instant> DATA_PULL_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dataPullStartTime").getter(ExecutionRecord.getter(ExecutionRecord::dataPullStartTime)).setter(ExecutionRecord.setter(Builder::dataPullStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPullStartTime").build()}).build();
    private static final SdkField<Instant> DATA_PULL_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("dataPullEndTime").getter(ExecutionRecord.getter(ExecutionRecord::dataPullEndTime)).setter(ExecutionRecord.setter(Builder::dataPullEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPullEndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, EXECUTION_STATUS_FIELD, EXECUTION_RESULT_FIELD, STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, DATA_PULL_START_TIME_FIELD, DATA_PULL_END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionId;
    private final String executionStatus;
    private final ExecutionResult executionResult;
    private final Instant startedAt;
    private final Instant lastUpdatedAt;
    private final Instant dataPullStartTime;
    private final Instant dataPullEndTime;

    private ExecutionRecord(BuilderImpl builder) {
        this.executionId = builder.executionId;
        this.executionStatus = builder.executionStatus;
        this.executionResult = builder.executionResult;
        this.startedAt = builder.startedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.dataPullStartTime = builder.dataPullStartTime;
        this.dataPullEndTime = builder.dataPullEndTime;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final ExecutionResult executionResult() {
        return this.executionResult;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant dataPullStartTime() {
        return this.dataPullStartTime;
    }

    public final Instant dataPullEndTime() {
        return this.dataPullEndTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPullStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPullEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionRecord)) {
            return false;
        }
        ExecutionRecord other = (ExecutionRecord)obj;
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.executionResult(), other.executionResult()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.dataPullStartTime(), other.dataPullStartTime()) && Objects.equals(this.dataPullEndTime(), other.dataPullEndTime());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionRecord").add("ExecutionId", (Object)this.executionId()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("ExecutionResult", (Object)this.executionResult()).add("StartedAt", (Object)this.startedAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("DataPullStartTime", (Object)this.dataPullStartTime()).add("DataPullEndTime", (Object)this.dataPullEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "executionResult": {
                return Optional.ofNullable(clazz.cast(this.executionResult()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "dataPullStartTime": {
                return Optional.ofNullable(clazz.cast(this.dataPullStartTime()));
            }
            case "dataPullEndTime": {
                return Optional.ofNullable(clazz.cast(this.dataPullEndTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecutionRecord, T> g) {
        return obj -> g.apply((ExecutionRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionId;
        private String executionStatus;
        private ExecutionResult executionResult;
        private Instant startedAt;
        private Instant lastUpdatedAt;
        private Instant dataPullStartTime;
        private Instant dataPullEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionRecord model) {
            this.executionId(model.executionId);
            this.executionStatus(model.executionStatus);
            this.executionResult(model.executionResult);
            this.startedAt(model.startedAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.dataPullStartTime(model.dataPullStartTime);
            this.dataPullEndTime(model.dataPullEndTime);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        @Transient
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        @Transient
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final ExecutionResult.Builder getExecutionResult() {
            return this.executionResult != null ? this.executionResult.toBuilder() : null;
        }

        public final void setExecutionResult(ExecutionResult.BuilderImpl executionResult) {
            this.executionResult = executionResult != null ? executionResult.build() : null;
        }

        @Override
        @Transient
        public final Builder executionResult(ExecutionResult executionResult) {
            this.executionResult = executionResult;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        @Transient
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getDataPullStartTime() {
            return this.dataPullStartTime;
        }

        public final void setDataPullStartTime(Instant dataPullStartTime) {
            this.dataPullStartTime = dataPullStartTime;
        }

        @Override
        @Transient
        public final Builder dataPullStartTime(Instant dataPullStartTime) {
            this.dataPullStartTime = dataPullStartTime;
            return this;
        }

        public final Instant getDataPullEndTime() {
            return this.dataPullEndTime;
        }

        public final void setDataPullEndTime(Instant dataPullEndTime) {
            this.dataPullEndTime = dataPullEndTime;
        }

        @Override
        @Transient
        public final Builder dataPullEndTime(Instant dataPullEndTime) {
            this.dataPullEndTime = dataPullEndTime;
            return this;
        }

        public ExecutionRecord build() {
            return new ExecutionRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionRecord> {
        public Builder executionId(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder executionResult(ExecutionResult var1);

        default public Builder executionResult(Consumer<ExecutionResult.Builder> executionResult) {
            return this.executionResult((ExecutionResult)((ExecutionResult.Builder)ExecutionResult.builder().applyMutation(executionResult)).build());
        }

        public Builder startedAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder dataPullStartTime(Instant var1);

        public Builder dataPullEndTime(Instant var1);
    }
}

