/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data model of a connector field. For example, for an <i>account</i> entity, the fields would be
 * <i>account name</i>, <i>account ID</i>, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectorEntityField implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectorEntityField.Builder, ConnectorEntityField> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(ConnectorEntityField::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("label")
            .getter(getter(ConnectorEntityField::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()).build();

    private static final SdkField<SupportedFieldTypeDetails> SUPPORTED_FIELD_TYPE_DETAILS_FIELD = SdkField
            .<SupportedFieldTypeDetails> builder(MarshallingType.SDK_POJO).memberName("supportedFieldTypeDetails")
            .getter(getter(ConnectorEntityField::supportedFieldTypeDetails)).setter(setter(Builder::supportedFieldTypeDetails))
            .constructor(SupportedFieldTypeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedFieldTypeDetails").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ConnectorEntityField::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SourceFieldProperties> SOURCE_PROPERTIES_FIELD = SdkField
            .<SourceFieldProperties> builder(MarshallingType.SDK_POJO).memberName("sourceProperties")
            .getter(getter(ConnectorEntityField::sourceProperties)).setter(setter(Builder::sourceProperties))
            .constructor(SourceFieldProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()).build();

    private static final SdkField<DestinationFieldProperties> DESTINATION_PROPERTIES_FIELD = SdkField
            .<DestinationFieldProperties> builder(MarshallingType.SDK_POJO).memberName("destinationProperties")
            .getter(getter(ConnectorEntityField::destinationProperties)).setter(setter(Builder::destinationProperties))
            .constructor(DestinationFieldProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LABEL_FIELD,
            SUPPORTED_FIELD_TYPE_DETAILS_FIELD, DESCRIPTION_FIELD, SOURCE_PROPERTIES_FIELD, DESTINATION_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final String label;

    private final SupportedFieldTypeDetails supportedFieldTypeDetails;

    private final String description;

    private final SourceFieldProperties sourceProperties;

    private final DestinationFieldProperties destinationProperties;

    private ConnectorEntityField(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.label = builder.label;
        this.supportedFieldTypeDetails = builder.supportedFieldTypeDetails;
        this.description = builder.description;
        this.sourceProperties = builder.sourceProperties;
        this.destinationProperties = builder.destinationProperties;
    }

    /**
     * <p>
     * The unique identifier of the connector field.
     * </p>
     * 
     * @return The unique identifier of the connector field.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The label applied to a connector entity field.
     * </p>
     * 
     * @return The label applied to a connector entity field.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * Contains details regarding the supported <code>FieldType</code>, including the corresponding
     * <code>filterOperators</code> and <code>supportedValues</code>.
     * </p>
     * 
     * @return Contains details regarding the supported <code>FieldType</code>, including the corresponding
     *         <code>filterOperators</code> and <code>supportedValues</code>.
     */
    public final SupportedFieldTypeDetails supportedFieldTypeDetails() {
        return supportedFieldTypeDetails;
    }

    /**
     * <p>
     * A description of the connector entity field.
     * </p>
     * 
     * @return A description of the connector entity field.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The properties that can be applied to a field when the connector is being used as a source.
     * </p>
     * 
     * @return The properties that can be applied to a field when the connector is being used as a source.
     */
    public final SourceFieldProperties sourceProperties() {
        return sourceProperties;
    }

    /**
     * <p>
     * The properties applied to a field when the connector is being used as a destination.
     * </p>
     * 
     * @return The properties applied to a field when the connector is being used as a destination.
     */
    public final DestinationFieldProperties destinationProperties() {
        return destinationProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(supportedFieldTypeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(destinationProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorEntityField)) {
            return false;
        }
        ConnectorEntityField other = (ConnectorEntityField) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(label(), other.label())
                && Objects.equals(supportedFieldTypeDetails(), other.supportedFieldTypeDetails())
                && Objects.equals(description(), other.description())
                && Objects.equals(sourceProperties(), other.sourceProperties())
                && Objects.equals(destinationProperties(), other.destinationProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectorEntityField").add("Identifier", identifier()).add("Label", label())
                .add("SupportedFieldTypeDetails", supportedFieldTypeDetails()).add("Description", description())
                .add("SourceProperties", sourceProperties()).add("DestinationProperties", destinationProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "label":
            return Optional.ofNullable(clazz.cast(label()));
        case "supportedFieldTypeDetails":
            return Optional.ofNullable(clazz.cast(supportedFieldTypeDetails()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sourceProperties":
            return Optional.ofNullable(clazz.cast(sourceProperties()));
        case "destinationProperties":
            return Optional.ofNullable(clazz.cast(destinationProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorEntityField, T> g) {
        return obj -> g.apply((ConnectorEntityField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectorEntityField> {
        /**
         * <p>
         * The unique identifier of the connector field.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the connector field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The label applied to a connector entity field.
         * </p>
         * 
         * @param label
         *        The label applied to a connector entity field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * Contains details regarding the supported <code>FieldType</code>, including the corresponding
         * <code>filterOperators</code> and <code>supportedValues</code>.
         * </p>
         * 
         * @param supportedFieldTypeDetails
         *        Contains details regarding the supported <code>FieldType</code>, including the corresponding
         *        <code>filterOperators</code> and <code>supportedValues</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFieldTypeDetails(SupportedFieldTypeDetails supportedFieldTypeDetails);

        /**
         * <p>
         * Contains details regarding the supported <code>FieldType</code>, including the corresponding
         * <code>filterOperators</code> and <code>supportedValues</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link SupportedFieldTypeDetails.Builder} avoiding the
         * need to create one manually via {@link SupportedFieldTypeDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link SupportedFieldTypeDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #supportedFieldTypeDetails(SupportedFieldTypeDetails)}.
         * 
         * @param supportedFieldTypeDetails
         *        a consumer that will call methods on {@link SupportedFieldTypeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #supportedFieldTypeDetails(SupportedFieldTypeDetails)
         */
        default Builder supportedFieldTypeDetails(Consumer<SupportedFieldTypeDetails.Builder> supportedFieldTypeDetails) {
            return supportedFieldTypeDetails(SupportedFieldTypeDetails.builder().applyMutation(supportedFieldTypeDetails).build());
        }

        /**
         * <p>
         * A description of the connector entity field.
         * </p>
         * 
         * @param description
         *        A description of the connector entity field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The properties that can be applied to a field when the connector is being used as a source.
         * </p>
         * 
         * @param sourceProperties
         *        The properties that can be applied to a field when the connector is being used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceProperties(SourceFieldProperties sourceProperties);

        /**
         * <p>
         * The properties that can be applied to a field when the connector is being used as a source.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceFieldProperties.Builder} avoiding the need
         * to create one manually via {@link SourceFieldProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceFieldProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceProperties(SourceFieldProperties)}.
         * 
         * @param sourceProperties
         *        a consumer that will call methods on {@link SourceFieldProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceProperties(SourceFieldProperties)
         */
        default Builder sourceProperties(Consumer<SourceFieldProperties.Builder> sourceProperties) {
            return sourceProperties(SourceFieldProperties.builder().applyMutation(sourceProperties).build());
        }

        /**
         * <p>
         * The properties applied to a field when the connector is being used as a destination.
         * </p>
         * 
         * @param destinationProperties
         *        The properties applied to a field when the connector is being used as a destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationProperties(DestinationFieldProperties destinationProperties);

        /**
         * <p>
         * The properties applied to a field when the connector is being used as a destination.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationFieldProperties.Builder} avoiding the
         * need to create one manually via {@link DestinationFieldProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationFieldProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #destinationProperties(DestinationFieldProperties)}.
         * 
         * @param destinationProperties
         *        a consumer that will call methods on {@link DestinationFieldProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationProperties(DestinationFieldProperties)
         */
        default Builder destinationProperties(Consumer<DestinationFieldProperties.Builder> destinationProperties) {
            return destinationProperties(DestinationFieldProperties.builder().applyMutation(destinationProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private String label;

        private SupportedFieldTypeDetails supportedFieldTypeDetails;

        private String description;

        private SourceFieldProperties sourceProperties;

        private DestinationFieldProperties destinationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorEntityField model) {
            identifier(model.identifier);
            label(model.label);
            supportedFieldTypeDetails(model.supportedFieldTypeDetails);
            description(model.description);
            sourceProperties(model.sourceProperties);
            destinationProperties(model.destinationProperties);
        }

        public final String getIdentifier() {
            return identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final SupportedFieldTypeDetails.Builder getSupportedFieldTypeDetails() {
            return supportedFieldTypeDetails != null ? supportedFieldTypeDetails.toBuilder() : null;
        }

        @Override
        public final Builder supportedFieldTypeDetails(SupportedFieldTypeDetails supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails;
            return this;
        }

        public final void setSupportedFieldTypeDetails(SupportedFieldTypeDetails.BuilderImpl supportedFieldTypeDetails) {
            this.supportedFieldTypeDetails = supportedFieldTypeDetails != null ? supportedFieldTypeDetails.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final SourceFieldProperties.Builder getSourceProperties() {
            return sourceProperties != null ? sourceProperties.toBuilder() : null;
        }

        @Override
        public final Builder sourceProperties(SourceFieldProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final void setSourceProperties(SourceFieldProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        public final DestinationFieldProperties.Builder getDestinationProperties() {
            return destinationProperties != null ? destinationProperties.toBuilder() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationFieldProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final void setDestinationProperties(DestinationFieldProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public ConnectorEntityField build() {
            return new ConnectorEntityField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
