/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.FilterOperatorListCopier;
import software.amazon.awssdk.services.appflow.model.Operator;
import software.amazon.awssdk.services.appflow.model.SupportedValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldTypeDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldTypeDetails> {
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldType").getter(FieldTypeDetails.getter(FieldTypeDetails::fieldType)).setter(FieldTypeDetails.setter(Builder::fieldType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldType").build()}).build();
    private static final SdkField<List<String>> FILTER_OPERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterOperators").getter(FieldTypeDetails.getter(FieldTypeDetails::filterOperatorsAsStrings)).setter(FieldTypeDetails.setter(Builder::filterOperatorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterOperators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedValues").getter(FieldTypeDetails.getter(FieldTypeDetails::supportedValues)).setter(FieldTypeDetails.setter(Builder::supportedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TYPE_FIELD, FILTER_OPERATORS_FIELD, SUPPORTED_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldType;
    private final List<String> filterOperators;
    private final List<String> supportedValues;

    private FieldTypeDetails(BuilderImpl builder) {
        this.fieldType = builder.fieldType;
        this.filterOperators = builder.filterOperators;
        this.supportedValues = builder.supportedValues;
    }

    public String fieldType() {
        return this.fieldType;
    }

    public List<Operator> filterOperators() {
        return FilterOperatorListCopier.copyStringToEnum(this.filterOperators);
    }

    public boolean hasFilterOperators() {
        return this.filterOperators != null && !(this.filterOperators instanceof SdkAutoConstructList);
    }

    public List<String> filterOperatorsAsStrings() {
        return this.filterOperators;
    }

    public boolean hasSupportedValues() {
        return this.supportedValues != null && !(this.supportedValues instanceof SdkAutoConstructList);
    }

    public List<String> supportedValues() {
        return this.supportedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldType());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterOperatorsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldTypeDetails)) {
            return false;
        }
        FieldTypeDetails other = (FieldTypeDetails)obj;
        return Objects.equals(this.fieldType(), other.fieldType()) && Objects.equals(this.filterOperatorsAsStrings(), other.filterOperatorsAsStrings()) && Objects.equals(this.supportedValues(), other.supportedValues());
    }

    public String toString() {
        return ToString.builder((String)"FieldTypeDetails").add("FieldType", (Object)this.fieldType()).add("FilterOperators", this.filterOperatorsAsStrings()).add("SupportedValues", this.supportedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldType": {
                return Optional.ofNullable(clazz.cast(this.fieldType()));
            }
            case "filterOperators": {
                return Optional.ofNullable(clazz.cast(this.filterOperatorsAsStrings()));
            }
            case "supportedValues": {
                return Optional.ofNullable(clazz.cast(this.supportedValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldTypeDetails, T> g) {
        return obj -> g.apply((FieldTypeDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldType;
        private List<String> filterOperators = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldTypeDetails model) {
            this.fieldType(model.fieldType);
            this.filterOperatorsWithStrings(model.filterOperators);
            this.supportedValues(model.supportedValues);
        }

        public final String getFieldType() {
            return this.fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        public final Collection<String> getFilterOperators() {
            return this.filterOperators;
        }

        @Override
        public final Builder filterOperatorsWithStrings(Collection<String> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copy(filterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperatorsWithStrings(String ... filterOperators) {
            this.filterOperatorsWithStrings(Arrays.asList(filterOperators));
            return this;
        }

        @Override
        public final Builder filterOperators(Collection<Operator> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copyEnumToString(filterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterOperators(Operator ... filterOperators) {
            this.filterOperators(Arrays.asList(filterOperators));
            return this;
        }

        public final void setFilterOperators(Collection<String> filterOperators) {
            this.filterOperators = FilterOperatorListCopier.copy(filterOperators);
        }

        public final Collection<String> getSupportedValues() {
            return this.supportedValues;
        }

        @Override
        public final Builder supportedValues(Collection<String> supportedValues) {
            this.supportedValues = SupportedValueListCopier.copy(supportedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedValues(String ... supportedValues) {
            this.supportedValues(Arrays.asList(supportedValues));
            return this;
        }

        public final void setSupportedValues(Collection<String> supportedValues) {
            this.supportedValues = SupportedValueListCopier.copy(supportedValues);
        }

        public FieldTypeDetails build() {
            return new FieldTypeDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldTypeDetails> {
        public Builder fieldType(String var1);

        public Builder filterOperatorsWithStrings(Collection<String> var1);

        public Builder filterOperatorsWithStrings(String ... var1);

        public Builder filterOperators(Collection<Operator> var1);

        public Builder filterOperators(Operator ... var1);

        public Builder supportedValues(Collection<String> var1);

        public Builder supportedValues(String ... var1);
    }
}

