/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appflow.model.ConnectorMetadata;
import software.amazon.awssdk.services.appflow.model.ConnectorType;
import software.amazon.awssdk.services.appflow.model.ConnectorTypeListCopier;
import software.amazon.awssdk.services.appflow.model.ScheduleFrequencyType;
import software.amazon.awssdk.services.appflow.model.SchedulingFrequencyTypeListCopier;
import software.amazon.awssdk.services.appflow.model.TriggerType;
import software.amazon.awssdk.services.appflow.model.TriggerTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorConfiguration> {
    private static final SdkField<Boolean> CAN_USE_AS_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConnectorConfiguration.getter(ConnectorConfiguration::canUseAsSource)).setter(ConnectorConfiguration.setter(Builder::canUseAsSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsSource").build()}).build();
    private static final SdkField<Boolean> CAN_USE_AS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConnectorConfiguration.getter(ConnectorConfiguration::canUseAsDestination)).setter(ConnectorConfiguration.setter(Builder::canUseAsDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canUseAsDestination").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_DESTINATION_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedDestinationConnectorsAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedDestinationConnectorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedDestinationConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_SCHEDULING_FREQUENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedSchedulingFrequenciesAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedSchedulingFrequenciesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedSchedulingFrequencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConnectorConfiguration.getter(ConnectorConfiguration::isPrivateLinkEnabled)).setter(ConnectorConfiguration.setter(Builder::isPrivateLinkEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEnabled").build()}).build();
    private static final SdkField<Boolean> IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConnectorConfiguration.getter(ConnectorConfiguration::isPrivateLinkEndpointUrlRequired)).setter(ConnectorConfiguration.setter(Builder::isPrivateLinkEndpointUrlRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPrivateLinkEndpointUrlRequired").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_TRIGGER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ConnectorConfiguration.getter(ConnectorConfiguration::supportedTriggerTypesAsStrings)).setter(ConnectorConfiguration.setter(Builder::supportedTriggerTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedTriggerTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConnectorMetadata> CONNECTOR_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConnectorConfiguration.getter(ConnectorConfiguration::connectorMetadata)).setter(ConnectorConfiguration.setter(Builder::connectorMetadata)).constructor(ConnectorMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAN_USE_AS_SOURCE_FIELD, CAN_USE_AS_DESTINATION_FIELD, SUPPORTED_DESTINATION_CONNECTORS_FIELD, SUPPORTED_SCHEDULING_FREQUENCIES_FIELD, IS_PRIVATE_LINK_ENABLED_FIELD, IS_PRIVATE_LINK_ENDPOINT_URL_REQUIRED_FIELD, SUPPORTED_TRIGGER_TYPES_FIELD, CONNECTOR_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean canUseAsSource;
    private final Boolean canUseAsDestination;
    private final List<String> supportedDestinationConnectors;
    private final List<String> supportedSchedulingFrequencies;
    private final Boolean isPrivateLinkEnabled;
    private final Boolean isPrivateLinkEndpointUrlRequired;
    private final List<String> supportedTriggerTypes;
    private final ConnectorMetadata connectorMetadata;

    private ConnectorConfiguration(BuilderImpl builder) {
        this.canUseAsSource = builder.canUseAsSource;
        this.canUseAsDestination = builder.canUseAsDestination;
        this.supportedDestinationConnectors = builder.supportedDestinationConnectors;
        this.supportedSchedulingFrequencies = builder.supportedSchedulingFrequencies;
        this.isPrivateLinkEnabled = builder.isPrivateLinkEnabled;
        this.isPrivateLinkEndpointUrlRequired = builder.isPrivateLinkEndpointUrlRequired;
        this.supportedTriggerTypes = builder.supportedTriggerTypes;
        this.connectorMetadata = builder.connectorMetadata;
    }

    public Boolean canUseAsSource() {
        return this.canUseAsSource;
    }

    public Boolean canUseAsDestination() {
        return this.canUseAsDestination;
    }

    public List<ConnectorType> supportedDestinationConnectors() {
        return ConnectorTypeListCopier.copyStringToEnum(this.supportedDestinationConnectors);
    }

    public boolean hasSupportedDestinationConnectors() {
        return this.supportedDestinationConnectors != null && !(this.supportedDestinationConnectors instanceof SdkAutoConstructList);
    }

    public List<String> supportedDestinationConnectorsAsStrings() {
        return this.supportedDestinationConnectors;
    }

    public List<ScheduleFrequencyType> supportedSchedulingFrequencies() {
        return SchedulingFrequencyTypeListCopier.copyStringToEnum(this.supportedSchedulingFrequencies);
    }

    public boolean hasSupportedSchedulingFrequencies() {
        return this.supportedSchedulingFrequencies != null && !(this.supportedSchedulingFrequencies instanceof SdkAutoConstructList);
    }

    public List<String> supportedSchedulingFrequenciesAsStrings() {
        return this.supportedSchedulingFrequencies;
    }

    public Boolean isPrivateLinkEnabled() {
        return this.isPrivateLinkEnabled;
    }

    public Boolean isPrivateLinkEndpointUrlRequired() {
        return this.isPrivateLinkEndpointUrlRequired;
    }

    public List<TriggerType> supportedTriggerTypes() {
        return TriggerTypeListCopier.copyStringToEnum(this.supportedTriggerTypes);
    }

    public boolean hasSupportedTriggerTypes() {
        return this.supportedTriggerTypes != null && !(this.supportedTriggerTypes instanceof SdkAutoConstructList);
    }

    public List<String> supportedTriggerTypesAsStrings() {
        return this.supportedTriggerTypes;
    }

    public ConnectorMetadata connectorMetadata() {
        return this.connectorMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.canUseAsSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.canUseAsDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedDestinationConnectorsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedSchedulingFrequenciesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrivateLinkEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPrivateLinkEndpointUrlRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedTriggerTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorMetadata());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorConfiguration)) {
            return false;
        }
        ConnectorConfiguration other = (ConnectorConfiguration)obj;
        return Objects.equals(this.canUseAsSource(), other.canUseAsSource()) && Objects.equals(this.canUseAsDestination(), other.canUseAsDestination()) && Objects.equals(this.supportedDestinationConnectorsAsStrings(), other.supportedDestinationConnectorsAsStrings()) && Objects.equals(this.supportedSchedulingFrequenciesAsStrings(), other.supportedSchedulingFrequenciesAsStrings()) && Objects.equals(this.isPrivateLinkEnabled(), other.isPrivateLinkEnabled()) && Objects.equals(this.isPrivateLinkEndpointUrlRequired(), other.isPrivateLinkEndpointUrlRequired()) && Objects.equals(this.supportedTriggerTypesAsStrings(), other.supportedTriggerTypesAsStrings()) && Objects.equals(this.connectorMetadata(), other.connectorMetadata());
    }

    public String toString() {
        return ToString.builder((String)"ConnectorConfiguration").add("CanUseAsSource", (Object)this.canUseAsSource()).add("CanUseAsDestination", (Object)this.canUseAsDestination()).add("SupportedDestinationConnectors", this.supportedDestinationConnectorsAsStrings()).add("SupportedSchedulingFrequencies", this.supportedSchedulingFrequenciesAsStrings()).add("IsPrivateLinkEnabled", (Object)this.isPrivateLinkEnabled()).add("IsPrivateLinkEndpointUrlRequired", (Object)this.isPrivateLinkEndpointUrlRequired()).add("SupportedTriggerTypes", this.supportedTriggerTypesAsStrings()).add("ConnectorMetadata", (Object)this.connectorMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "canUseAsSource": {
                return Optional.ofNullable(clazz.cast(this.canUseAsSource()));
            }
            case "canUseAsDestination": {
                return Optional.ofNullable(clazz.cast(this.canUseAsDestination()));
            }
            case "supportedDestinationConnectors": {
                return Optional.ofNullable(clazz.cast(this.supportedDestinationConnectorsAsStrings()));
            }
            case "supportedSchedulingFrequencies": {
                return Optional.ofNullable(clazz.cast(this.supportedSchedulingFrequenciesAsStrings()));
            }
            case "isPrivateLinkEnabled": {
                return Optional.ofNullable(clazz.cast(this.isPrivateLinkEnabled()));
            }
            case "isPrivateLinkEndpointUrlRequired": {
                return Optional.ofNullable(clazz.cast(this.isPrivateLinkEndpointUrlRequired()));
            }
            case "supportedTriggerTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedTriggerTypesAsStrings()));
            }
            case "connectorMetadata": {
                return Optional.ofNullable(clazz.cast(this.connectorMetadata()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorConfiguration, T> g) {
        return obj -> g.apply((ConnectorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean canUseAsSource;
        private Boolean canUseAsDestination;
        private List<String> supportedDestinationConnectors = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedSchedulingFrequencies = DefaultSdkAutoConstructList.getInstance();
        private Boolean isPrivateLinkEnabled;
        private Boolean isPrivateLinkEndpointUrlRequired;
        private List<String> supportedTriggerTypes = DefaultSdkAutoConstructList.getInstance();
        private ConnectorMetadata connectorMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorConfiguration model) {
            this.canUseAsSource(model.canUseAsSource);
            this.canUseAsDestination(model.canUseAsDestination);
            this.supportedDestinationConnectorsWithStrings(model.supportedDestinationConnectors);
            this.supportedSchedulingFrequenciesWithStrings(model.supportedSchedulingFrequencies);
            this.isPrivateLinkEnabled(model.isPrivateLinkEnabled);
            this.isPrivateLinkEndpointUrlRequired(model.isPrivateLinkEndpointUrlRequired);
            this.supportedTriggerTypesWithStrings(model.supportedTriggerTypes);
            this.connectorMetadata(model.connectorMetadata);
        }

        public final Boolean getCanUseAsSource() {
            return this.canUseAsSource;
        }

        @Override
        public final Builder canUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
            return this;
        }

        public final void setCanUseAsSource(Boolean canUseAsSource) {
            this.canUseAsSource = canUseAsSource;
        }

        public final Boolean getCanUseAsDestination() {
            return this.canUseAsDestination;
        }

        @Override
        public final Builder canUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
            return this;
        }

        public final void setCanUseAsDestination(Boolean canUseAsDestination) {
            this.canUseAsDestination = canUseAsDestination;
        }

        public final Collection<String> getSupportedDestinationConnectors() {
            return this.supportedDestinationConnectors;
        }

        @Override
        public final Builder supportedDestinationConnectorsWithStrings(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectorsWithStrings(String ... supportedDestinationConnectors) {
            this.supportedDestinationConnectorsWithStrings(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        @Override
        public final Builder supportedDestinationConnectors(Collection<ConnectorType> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copyEnumToString(supportedDestinationConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDestinationConnectors(ConnectorType ... supportedDestinationConnectors) {
            this.supportedDestinationConnectors(Arrays.asList(supportedDestinationConnectors));
            return this;
        }

        public final void setSupportedDestinationConnectors(Collection<String> supportedDestinationConnectors) {
            this.supportedDestinationConnectors = ConnectorTypeListCopier.copy(supportedDestinationConnectors);
        }

        public final Collection<String> getSupportedSchedulingFrequencies() {
            return this.supportedSchedulingFrequencies;
        }

        @Override
        public final Builder supportedSchedulingFrequenciesWithStrings(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequenciesWithStrings(String ... supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequenciesWithStrings(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        @Override
        public final Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copyEnumToString(supportedSchedulingFrequencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedSchedulingFrequencies(ScheduleFrequencyType ... supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies(Arrays.asList(supportedSchedulingFrequencies));
            return this;
        }

        public final void setSupportedSchedulingFrequencies(Collection<String> supportedSchedulingFrequencies) {
            this.supportedSchedulingFrequencies = SchedulingFrequencyTypeListCopier.copy(supportedSchedulingFrequencies);
        }

        public final Boolean getIsPrivateLinkEnabled() {
            return this.isPrivateLinkEnabled;
        }

        @Override
        public final Builder isPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
            return this;
        }

        public final void setIsPrivateLinkEnabled(Boolean isPrivateLinkEnabled) {
            this.isPrivateLinkEnabled = isPrivateLinkEnabled;
        }

        public final Boolean getIsPrivateLinkEndpointUrlRequired() {
            return this.isPrivateLinkEndpointUrlRequired;
        }

        @Override
        public final Builder isPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
            return this;
        }

        public final void setIsPrivateLinkEndpointUrlRequired(Boolean isPrivateLinkEndpointUrlRequired) {
            this.isPrivateLinkEndpointUrlRequired = isPrivateLinkEndpointUrlRequired;
        }

        public final Collection<String> getSupportedTriggerTypes() {
            return this.supportedTriggerTypes;
        }

        @Override
        public final Builder supportedTriggerTypesWithStrings(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypesWithStrings(String ... supportedTriggerTypes) {
            this.supportedTriggerTypesWithStrings(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        @Override
        public final Builder supportedTriggerTypes(Collection<TriggerType> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copyEnumToString(supportedTriggerTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedTriggerTypes(TriggerType ... supportedTriggerTypes) {
            this.supportedTriggerTypes(Arrays.asList(supportedTriggerTypes));
            return this;
        }

        public final void setSupportedTriggerTypes(Collection<String> supportedTriggerTypes) {
            this.supportedTriggerTypes = TriggerTypeListCopier.copy(supportedTriggerTypes);
        }

        public final ConnectorMetadata.Builder getConnectorMetadata() {
            return this.connectorMetadata != null ? this.connectorMetadata.toBuilder() : null;
        }

        @Override
        public final Builder connectorMetadata(ConnectorMetadata connectorMetadata) {
            this.connectorMetadata = connectorMetadata;
            return this;
        }

        public final void setConnectorMetadata(ConnectorMetadata.BuilderImpl connectorMetadata) {
            this.connectorMetadata = connectorMetadata != null ? connectorMetadata.build() : null;
        }

        public ConnectorConfiguration build() {
            return new ConnectorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorConfiguration> {
        public Builder canUseAsSource(Boolean var1);

        public Builder canUseAsDestination(Boolean var1);

        public Builder supportedDestinationConnectorsWithStrings(Collection<String> var1);

        public Builder supportedDestinationConnectorsWithStrings(String ... var1);

        public Builder supportedDestinationConnectors(Collection<ConnectorType> var1);

        public Builder supportedDestinationConnectors(ConnectorType ... var1);

        public Builder supportedSchedulingFrequenciesWithStrings(Collection<String> var1);

        public Builder supportedSchedulingFrequenciesWithStrings(String ... var1);

        public Builder supportedSchedulingFrequencies(Collection<ScheduleFrequencyType> var1);

        public Builder supportedSchedulingFrequencies(ScheduleFrequencyType ... var1);

        public Builder isPrivateLinkEnabled(Boolean var1);

        public Builder isPrivateLinkEndpointUrlRequired(Boolean var1);

        public Builder supportedTriggerTypesWithStrings(Collection<String> var1);

        public Builder supportedTriggerTypesWithStrings(String ... var1);

        public Builder supportedTriggerTypes(Collection<TriggerType> var1);

        public Builder supportedTriggerTypes(TriggerType ... var1);

        public Builder connectorMetadata(ConnectorMetadata var1);

        default public Builder connectorMetadata(Consumer<ConnectorMetadata.Builder> connectorMetadata) {
            return this.connectorMetadata((ConnectorMetadata)((ConnectorMetadata.Builder)ConnectorMetadata.builder().applyMutation(connectorMetadata)).build());
        }
    }
}

