/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfigdata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.appconfigdata.AppConfigDataClientBuilder;
import software.amazon.awssdk.services.appconfigdata.DefaultAppConfigDataClientBuilder;
import software.amazon.awssdk.services.appconfigdata.model.AppConfigDataException;
import software.amazon.awssdk.services.appconfigdata.model.BadRequestException;
import software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationRequest;
import software.amazon.awssdk.services.appconfigdata.model.GetLatestConfigurationResponse;
import software.amazon.awssdk.services.appconfigdata.model.InternalServerException;
import software.amazon.awssdk.services.appconfigdata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionRequest;
import software.amazon.awssdk.services.appconfigdata.model.StartConfigurationSessionResponse;
import software.amazon.awssdk.services.appconfigdata.model.ThrottlingException;

@SdkPublicApi
@ThreadSafe
public interface AppConfigDataClient
extends SdkClient {
    public static final String SERVICE_NAME = "appconfig";
    public static final String SERVICE_METADATA_ID = "appconfigdata";

    public static AppConfigDataClient create() {
        return (AppConfigDataClient)AppConfigDataClient.builder().build();
    }

    public static AppConfigDataClientBuilder builder() {
        return new DefaultAppConfigDataClientBuilder();
    }

    default public GetLatestConfigurationResponse getLatestConfiguration(GetLatestConfigurationRequest getLatestConfigurationRequest) throws ThrottlingException, ResourceNotFoundException, BadRequestException, InternalServerException, AwsServiceException, SdkClientException, AppConfigDataException {
        throw new UnsupportedOperationException();
    }

    default public GetLatestConfigurationResponse getLatestConfiguration(Consumer<GetLatestConfigurationRequest.Builder> getLatestConfigurationRequest) throws ThrottlingException, ResourceNotFoundException, BadRequestException, InternalServerException, AwsServiceException, SdkClientException, AppConfigDataException {
        return this.getLatestConfiguration((GetLatestConfigurationRequest)((Object)((GetLatestConfigurationRequest.Builder)GetLatestConfigurationRequest.builder().applyMutation(getLatestConfigurationRequest)).build()));
    }

    default public StartConfigurationSessionResponse startConfigurationSession(StartConfigurationSessionRequest startConfigurationSessionRequest) throws ThrottlingException, ResourceNotFoundException, BadRequestException, InternalServerException, AwsServiceException, SdkClientException, AppConfigDataException {
        throw new UnsupportedOperationException();
    }

    default public StartConfigurationSessionResponse startConfigurationSession(Consumer<StartConfigurationSessionRequest.Builder> startConfigurationSessionRequest) throws ThrottlingException, ResourceNotFoundException, BadRequestException, InternalServerException, AwsServiceException, SdkClientException, AppConfigDataException {
        return this.startConfigurationSession((StartConfigurationSessionRequest)((Object)((StartConfigurationSessionRequest.Builder)StartConfigurationSessionRequest.builder().applyMutation(startConfigurationSessionRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }
}

