/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentRequest;
import software.amazon.awssdk.services.appconfig.model.GetDeploymentResponse;
import software.amazon.awssdk.services.appconfig.model.GetEnvironmentRequest;
import software.amazon.awssdk.services.appconfig.model.GetEnvironmentResponse;
import software.amazon.awssdk.services.appconfig.waiters.DefaultAppConfigAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface AppConfigAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentComplete(GetDeploymentRequest getDeploymentRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentComplete(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest) {
        return this.waitUntilDeploymentComplete((GetDeploymentRequest)((Object)((GetDeploymentRequest.Builder)GetDeploymentRequest.builder().applyMutation(getDeploymentRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentComplete(GetDeploymentRequest getDeploymentRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetDeploymentResponse>> waitUntilDeploymentComplete(Consumer<GetDeploymentRequest.Builder> getDeploymentRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilDeploymentComplete((GetDeploymentRequest)((Object)((GetDeploymentRequest.Builder)GetDeploymentRequest.builder().applyMutation(getDeploymentRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentReadyForDeployment(GetEnvironmentRequest getEnvironmentRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentReadyForDeployment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest) {
        return this.waitUntilEnvironmentReadyForDeployment((GetEnvironmentRequest)((Object)((GetEnvironmentRequest.Builder)GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentReadyForDeployment(GetEnvironmentRequest getEnvironmentRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetEnvironmentResponse>> waitUntilEnvironmentReadyForDeployment(Consumer<GetEnvironmentRequest.Builder> getEnvironmentRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilEnvironmentReadyForDeployment((GetEnvironmentRequest)((Object)((GetEnvironmentRequest.Builder)GetEnvironmentRequest.builder().applyMutation(getEnvironmentRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultAppConfigAsyncWaiter.builder();
    }

    public static AppConfigAsyncWaiter create() {
        return DefaultAppConfigAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(AppConfigAsyncClient var1);

        public AppConfigAsyncWaiter build();
    }
}

