/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.appconfig.model.ExtensionAssociationSummary;
import software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsRequest;
import software.amazon.awssdk.services.appconfig.model.ListExtensionAssociationsResponse;

public class ListExtensionAssociationsIterable
implements SdkIterable<ListExtensionAssociationsResponse> {
    private final AppConfigClient client;
    private final ListExtensionAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExtensionAssociationsIterable(AppConfigClient client, ListExtensionAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExtensionAssociationsResponseFetcher();
    }

    public Iterator<ListExtensionAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExtensionAssociationSummary> items() {
        Function<ListExtensionAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExtensionAssociationsResponseFetcher
    implements SyncPageFetcher<ListExtensionAssociationsResponse> {
        private ListExtensionAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensionAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExtensionAssociationsResponse nextPage(ListExtensionAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListExtensionAssociationsIterable.this.client.listExtensionAssociations(ListExtensionAssociationsIterable.this.firstRequest);
            }
            return ListExtensionAssociationsIterable.this.client.listExtensionAssociations((ListExtensionAssociationsRequest)((Object)ListExtensionAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

