/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.services.appconfig.model.ParameterValueMapCopier;
import software.amazon.awssdk.services.appconfig.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateExtensionAssociationRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, CreateExtensionAssociationRequest> {
    private static final SdkField<String> EXTENSION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtensionIdentifier").getter(CreateExtensionAssociationRequest.getter(CreateExtensionAssociationRequest::extensionIdentifier)).setter(CreateExtensionAssociationRequest.setter(Builder::extensionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionIdentifier").build()}).build();
    private static final SdkField<Integer> EXTENSION_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExtensionVersionNumber").getter(CreateExtensionAssociationRequest.getter(CreateExtensionAssociationRequest::extensionVersionNumber)).setter(CreateExtensionAssociationRequest.setter(Builder::extensionVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtensionVersionNumber").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(CreateExtensionAssociationRequest.getter(CreateExtensionAssociationRequest::resourceIdentifier)).setter(CreateExtensionAssociationRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(CreateExtensionAssociationRequest.getter(CreateExtensionAssociationRequest::parameters)).setter(CreateExtensionAssociationRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateExtensionAssociationRequest.getter(CreateExtensionAssociationRequest::tags)).setter(CreateExtensionAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENSION_IDENTIFIER_FIELD, EXTENSION_VERSION_NUMBER_FIELD, RESOURCE_IDENTIFIER_FIELD, PARAMETERS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateExtensionAssociationRequest.memberNameToFieldInitializer();
    private final String extensionIdentifier;
    private final Integer extensionVersionNumber;
    private final String resourceIdentifier;
    private final Map<String, String> parameters;
    private final Map<String, String> tags;

    private CreateExtensionAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.extensionIdentifier = builder.extensionIdentifier;
        this.extensionVersionNumber = builder.extensionVersionNumber;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.parameters = builder.parameters;
        this.tags = builder.tags;
    }

    public final String extensionIdentifier() {
        return this.extensionIdentifier;
    }

    public final Integer extensionVersionNumber() {
        return this.extensionVersionNumber;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.extensionVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateExtensionAssociationRequest)) {
            return false;
        }
        CreateExtensionAssociationRequest other = (CreateExtensionAssociationRequest)((Object)obj);
        return Objects.equals(this.extensionIdentifier(), other.extensionIdentifier()) && Objects.equals(this.extensionVersionNumber(), other.extensionVersionNumber()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateExtensionAssociationRequest").add("ExtensionIdentifier", (Object)this.extensionIdentifier()).add("ExtensionVersionNumber", (Object)this.extensionVersionNumber()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExtensionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.extensionIdentifier()));
            }
            case "ExtensionVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.extensionVersionNumber()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExtensionIdentifier", EXTENSION_IDENTIFIER_FIELD);
        map.put("ExtensionVersionNumber", EXTENSION_VERSION_NUMBER_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateExtensionAssociationRequest, T> g) {
        return obj -> g.apply((CreateExtensionAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String extensionIdentifier;
        private Integer extensionVersionNumber;
        private String resourceIdentifier;
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateExtensionAssociationRequest model) {
            super(model);
            this.extensionIdentifier(model.extensionIdentifier);
            this.extensionVersionNumber(model.extensionVersionNumber);
            this.resourceIdentifier(model.resourceIdentifier);
            this.parameters(model.parameters);
            this.tags(model.tags);
        }

        public final String getExtensionIdentifier() {
            return this.extensionIdentifier;
        }

        public final void setExtensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
        }

        @Override
        public final Builder extensionIdentifier(String extensionIdentifier) {
            this.extensionIdentifier = extensionIdentifier;
            return this;
        }

        public final Integer getExtensionVersionNumber() {
            return this.extensionVersionNumber;
        }

        public final void setExtensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
        }

        @Override
        public final Builder extensionVersionNumber(Integer extensionVersionNumber) {
            this.extensionVersionNumber = extensionVersionNumber;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParameterValueMapCopier.copy(parameters);
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateExtensionAssociationRequest build() {
            return new CreateExtensionAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateExtensionAssociationRequest> {
        public Builder extensionIdentifier(String var1);

        public Builder extensionVersionNumber(Integer var1);

        public Builder resourceIdentifier(String var1);

        public Builder parameters(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

