/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.appconfig.model.DeploymentSummary;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.appconfig.model.ListDeploymentsResponse;

public class ListDeploymentsPublisher
implements SdkPublisher<ListDeploymentsResponse> {
    private final AppConfigAsyncClient client;
    private final ListDeploymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentsPublisher(AppConfigAsyncClient client, ListDeploymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentsPublisher(AppConfigAsyncClient client, ListDeploymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeploymentSummary> items() {
        Function<ListDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDeploymentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDeploymentsResponseFetcher
    implements AsyncPageFetcher<ListDeploymentsResponse> {
        private ListDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDeploymentsResponse> nextPage(ListDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentsPublisher.this.client.listDeployments(ListDeploymentsPublisher.this.firstRequest);
            }
            return ListDeploymentsPublisher.this.client.listDeployments((ListDeploymentsRequest)((Object)ListDeploymentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

