/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigAsyncClient;
import software.amazon.awssdk.services.appconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.appconfig.model.ListExtensionsRequest;
import software.amazon.awssdk.services.appconfig.model.ListExtensionsResponse;

public class ListExtensionsPublisher
implements SdkPublisher<ListExtensionsResponse> {
    private final AppConfigAsyncClient client;
    private final ListExtensionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExtensionsPublisher(AppConfigAsyncClient client, ListExtensionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExtensionsPublisher(AppConfigAsyncClient client, ListExtensionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExtensionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExtensionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExtensionsResponseFetcher
    implements AsyncPageFetcher<ListExtensionsResponse> {
        private ListExtensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListExtensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExtensionsResponse> nextPage(ListExtensionsResponse previousPage) {
            if (previousPage == null) {
                return ListExtensionsPublisher.this.client.listExtensions(ListExtensionsPublisher.this.firstRequest);
            }
            return ListExtensionsPublisher.this.client.listExtensions((ListExtensionsRequest)((Object)ListExtensionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

