/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsRequest;
import software.amazon.awssdk.services.appconfig.model.ListHostedConfigurationVersionsResponse;

public class ListHostedConfigurationVersionsIterable
implements SdkIterable<ListHostedConfigurationVersionsResponse> {
    private final AppConfigClient client;
    private final ListHostedConfigurationVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHostedConfigurationVersionsIterable(AppConfigClient client, ListHostedConfigurationVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHostedConfigurationVersionsResponseFetcher();
    }

    public Iterator<ListHostedConfigurationVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListHostedConfigurationVersionsResponseFetcher
    implements SyncPageFetcher<ListHostedConfigurationVersionsResponse> {
        private ListHostedConfigurationVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListHostedConfigurationVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHostedConfigurationVersionsResponse nextPage(ListHostedConfigurationVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListHostedConfigurationVersionsIterable.this.client.listHostedConfigurationVersions(ListHostedConfigurationVersionsIterable.this.firstRequest);
            }
            return ListHostedConfigurationVersionsIterable.this.client.listHostedConfigurationVersions((ListHostedConfigurationVersionsRequest)((Object)ListHostedConfigurationVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

