/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appconfig.model.AppConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConfigurationRequest
extends AppConfigRequest
implements ToCopyableBuilder<Builder, GetConfigurationRequest> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Application").getter(GetConfigurationRequest.getter(GetConfigurationRequest::application)).setter(GetConfigurationRequest.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Application").build()}).build();
    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Environment").getter(GetConfigurationRequest.getter(GetConfigurationRequest::environment)).setter(GetConfigurationRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Environment").build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Configuration").getter(GetConfigurationRequest.getter(GetConfigurationRequest::configuration)).setter(GetConfigurationRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Configuration").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(GetConfigurationRequest.getter(GetConfigurationRequest::clientId)).setter(GetConfigurationRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("client_id").build()}).build();
    private static final SdkField<String> CLIENT_CONFIGURATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientConfigurationVersion").getter(GetConfigurationRequest.getter(GetConfigurationRequest::clientConfigurationVersion)).setter(GetConfigurationRequest.setter(Builder::clientConfigurationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("client_configuration_version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, ENVIRONMENT_FIELD, CONFIGURATION_FIELD, CLIENT_ID_FIELD, CLIENT_CONFIGURATION_VERSION_FIELD));
    private final String application;
    private final String environment;
    private final String configuration;
    private final String clientId;
    private final String clientConfigurationVersion;

    private GetConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.application = builder.application;
        this.environment = builder.environment;
        this.configuration = builder.configuration;
        this.clientId = builder.clientId;
        this.clientConfigurationVersion = builder.clientConfigurationVersion;
    }

    public String application() {
        return this.application;
    }

    public String environment() {
        return this.environment;
    }

    public String configuration() {
        return this.configuration;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientConfigurationVersion() {
        return this.clientConfigurationVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientConfigurationVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationRequest)) {
            return false;
        }
        GetConfigurationRequest other = (GetConfigurationRequest)((Object)obj);
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientConfigurationVersion(), other.clientConfigurationVersion());
    }

    public String toString() {
        return ToString.builder((String)"GetConfigurationRequest").add("Application", (Object)this.application()).add("Environment", (Object)this.environment()).add("Configuration", (Object)this.configuration()).add("ClientId", (Object)this.clientId()).add("ClientConfigurationVersion", (Object)this.clientConfigurationVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ClientConfigurationVersion": {
                return Optional.ofNullable(clazz.cast(this.clientConfigurationVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationRequest, T> g) {
        return obj -> g.apply((GetConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigRequest.BuilderImpl
    implements Builder {
        private String application;
        private String environment;
        private String configuration;
        private String clientId;
        private String clientConfigurationVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationRequest model) {
            super(model);
            this.application(model.application);
            this.environment(model.environment);
            this.configuration(model.configuration);
            this.clientId(model.clientId);
            this.clientConfigurationVersion(model.clientConfigurationVersion);
        }

        public final String getApplication() {
            return this.application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientConfigurationVersion() {
            return this.clientConfigurationVersion;
        }

        @Override
        public final Builder clientConfigurationVersion(String clientConfigurationVersion) {
            this.clientConfigurationVersion = clientConfigurationVersion;
            return this;
        }

        public final void setClientConfigurationVersion(String clientConfigurationVersion) {
            this.clientConfigurationVersion = clientConfigurationVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConfigurationRequest build() {
            return new GetConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConfigurationRequest> {
        public Builder application(String var1);

        public Builder environment(String var1);

        public Builder configuration(String var1);

        public Builder clientId(String var1);

        public Builder clientConfigurationVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

