/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appconfig.model.AppConfigResponse;
import software.amazon.awssdk.services.appconfig.model.EnvironmentState;
import software.amazon.awssdk.services.appconfig.model.Monitor;
import software.amazon.awssdk.services.appconfig.model.MonitorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnvironmentResponse
extends AppConfigResponse
implements ToCopyableBuilder<Builder, UpdateEnvironmentResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(UpdateEnvironmentResponse.getter(UpdateEnvironmentResponse::applicationId)).setter(UpdateEnvironmentResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateEnvironmentResponse.getter(UpdateEnvironmentResponse::id)).setter(UpdateEnvironmentResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateEnvironmentResponse.getter(UpdateEnvironmentResponse::name)).setter(UpdateEnvironmentResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateEnvironmentResponse.getter(UpdateEnvironmentResponse::description)).setter(UpdateEnvironmentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(UpdateEnvironmentResponse.getter(UpdateEnvironmentResponse::stateAsString)).setter(UpdateEnvironmentResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<Monitor>> MONITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Monitors").getter(UpdateEnvironmentResponse.getter(UpdateEnvironmentResponse::monitors)).setter(UpdateEnvironmentResponse.setter(Builder::monitors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Monitor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, STATE_FIELD, MONITORS_FIELD));
    private final String applicationId;
    private final String id;
    private final String name;
    private final String description;
    private final String state;
    private final List<Monitor> monitors;

    private UpdateEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.state = builder.state;
        this.monitors = builder.monitors;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public EnvironmentState state() {
        return EnvironmentState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public boolean hasMonitors() {
        return this.monitors != null && !(this.monitors instanceof SdkAutoConstructList);
    }

    public List<Monitor> monitors() {
        return this.monitors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitors());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnvironmentResponse)) {
            return false;
        }
        UpdateEnvironmentResponse other = (UpdateEnvironmentResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.monitors(), other.monitors());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEnvironmentResponse").add("ApplicationId", (Object)this.applicationId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("State", (Object)this.stateAsString()).add("Monitors", this.monitors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Monitors": {
                return Optional.ofNullable(clazz.cast(this.monitors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnvironmentResponse, T> g) {
        return obj -> g.apply((UpdateEnvironmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppConfigResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String id;
        private String name;
        private String description;
        private String state;
        private List<Monitor> monitors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnvironmentResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.state(model.state);
            this.monitors(model.monitors);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EnvironmentState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<Monitor.Builder> getMonitors() {
            return this.monitors != null ? (Collection)this.monitors.stream().map(Monitor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder monitors(Collection<Monitor> monitors) {
            this.monitors = MonitorListCopier.copy(monitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Monitor ... monitors) {
            this.monitors(Arrays.asList(monitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitors(Consumer<Monitor.Builder> ... monitors) {
            this.monitors(Stream.of(monitors).map(c -> (Monitor)((Monitor.Builder)Monitor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMonitors(Collection<Monitor.BuilderImpl> monitors) {
            this.monitors = MonitorListCopier.copyFromBuilder(monitors);
        }

        @Override
        public UpdateEnvironmentResponse build() {
            return new UpdateEnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnvironmentResponse> {
        public Builder applicationId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder state(String var1);

        public Builder state(EnvironmentState var1);

        public Builder monitors(Collection<Monitor> var1);

        public Builder monitors(Monitor ... var1);

        public Builder monitors(Consumer<Monitor.Builder> ... var1);
    }
}

