/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BytesMeasure {
    KILOBYTES("KILOBYTES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BytesMeasure(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BytesMeasure fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BytesMeasure.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BytesMeasure> knownValues() {
        return Stream.of(BytesMeasure.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

