/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EnvironmentState {
    READY_FOR_DEPLOYMENT("READY_FOR_DEPLOYMENT"),
    DEPLOYING("DEPLOYING"),
    ROLLING_BACK("ROLLING_BACK"),
    ROLLED_BACK("ROLLED_BACK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EnvironmentState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EnvironmentState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EnvironmentState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EnvironmentState> knownValues() {
        return Stream.of(EnvironmentState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

