/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigatewayv2.model.AccessLogSettings;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Response;
import software.amazon.awssdk.services.apigatewayv2.model.RouteSettings;
import software.amazon.awssdk.services.apigatewayv2.model.RouteSettingsMapCopier;
import software.amazon.awssdk.services.apigatewayv2.model.StageVariablesMapCopier;
import software.amazon.awssdk.services.apigatewayv2.model.TagsCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStageResponse
extends ApiGatewayV2Response
implements ToCopyableBuilder<Builder, GetStageResponse> {
    private static final SdkField<AccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetStageResponse.getter(GetStageResponse::accessLogSettings)).setter(GetStageResponse.setter(Builder::accessLogSettings)).constructor(AccessLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogSettings").build()}).build();
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetStageResponse.getter(GetStageResponse::clientCertificateId)).setter(GetStageResponse.setter(Builder::clientCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateId").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetStageResponse.getter(GetStageResponse::createdDate)).setter(GetStageResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<RouteSettings> DEFAULT_ROUTE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetStageResponse.getter(GetStageResponse::defaultRouteSettings)).setter(GetStageResponse.setter(Builder::defaultRouteSettings)).constructor(RouteSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRouteSettings").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetStageResponse.getter(GetStageResponse::deploymentId)).setter(GetStageResponse.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetStageResponse.getter(GetStageResponse::description)).setter(GetStageResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetStageResponse.getter(GetStageResponse::lastUpdatedDate)).setter(GetStageResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, RouteSettings>> ROUTE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetStageResponse.getter(GetStageResponse::routeSettings)).setter(GetStageResponse.setter(Builder::routeSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeSettings").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouteSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetStageResponse.getter(GetStageResponse::stageName)).setter(GetStageResponse.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageName").build()}).build();
    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetStageResponse.getter(GetStageResponse::stageVariables)).setter(GetStageResponse.setter(Builder::stageVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(GetStageResponse.getter(GetStageResponse::tags)).setter(GetStageResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_SETTINGS_FIELD, CLIENT_CERTIFICATE_ID_FIELD, CREATED_DATE_FIELD, DEFAULT_ROUTE_SETTINGS_FIELD, DEPLOYMENT_ID_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_DATE_FIELD, ROUTE_SETTINGS_FIELD, STAGE_NAME_FIELD, STAGE_VARIABLES_FIELD, TAGS_FIELD));
    private final AccessLogSettings accessLogSettings;
    private final String clientCertificateId;
    private final Instant createdDate;
    private final RouteSettings defaultRouteSettings;
    private final String deploymentId;
    private final String description;
    private final Instant lastUpdatedDate;
    private final Map<String, RouteSettings> routeSettings;
    private final String stageName;
    private final Map<String, String> stageVariables;
    private final Map<String, String> tags;

    private GetStageResponse(BuilderImpl builder) {
        super(builder);
        this.accessLogSettings = builder.accessLogSettings;
        this.clientCertificateId = builder.clientCertificateId;
        this.createdDate = builder.createdDate;
        this.defaultRouteSettings = builder.defaultRouteSettings;
        this.deploymentId = builder.deploymentId;
        this.description = builder.description;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.routeSettings = builder.routeSettings;
        this.stageName = builder.stageName;
        this.stageVariables = builder.stageVariables;
        this.tags = builder.tags;
    }

    public AccessLogSettings accessLogSettings() {
        return this.accessLogSettings;
    }

    public String clientCertificateId() {
        return this.clientCertificateId;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public RouteSettings defaultRouteSettings() {
        return this.defaultRouteSettings;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String description() {
        return this.description;
    }

    public Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Map<String, RouteSettings> routeSettings() {
        return this.routeSettings;
    }

    public String stageName() {
        return this.stageName;
    }

    public Map<String, String> stageVariables() {
        return this.stageVariables;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageVariables());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStageResponse)) {
            return false;
        }
        GetStageResponse other = (GetStageResponse)((Object)obj);
        return Objects.equals(this.accessLogSettings(), other.accessLogSettings()) && Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.defaultRouteSettings(), other.defaultRouteSettings()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.routeSettings(), other.routeSettings()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.stageVariables(), other.stageVariables()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"GetStageResponse").add("AccessLogSettings", (Object)this.accessLogSettings()).add("ClientCertificateId", (Object)this.clientCertificateId()).add("CreatedDate", (Object)this.createdDate()).add("DefaultRouteSettings", (Object)this.defaultRouteSettings()).add("DeploymentId", (Object)this.deploymentId()).add("Description", (Object)this.description()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("RouteSettings", this.routeSettings()).add("StageName", (Object)this.stageName()).add("StageVariables", this.stageVariables()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessLogSettings": {
                return Optional.ofNullable(clazz.cast(this.accessLogSettings()));
            }
            case "ClientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "DefaultRouteSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteSettings()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "RouteSettings": {
                return Optional.ofNullable(clazz.cast(this.routeSettings()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "StageVariables": {
                return Optional.ofNullable(clazz.cast(this.stageVariables()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStageResponse, T> g) {
        return obj -> g.apply((GetStageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Response.BuilderImpl
    implements Builder {
        private AccessLogSettings accessLogSettings;
        private String clientCertificateId;
        private Instant createdDate;
        private RouteSettings defaultRouteSettings;
        private String deploymentId;
        private String description;
        private Instant lastUpdatedDate;
        private Map<String, RouteSettings> routeSettings = DefaultSdkAutoConstructMap.getInstance();
        private String stageName;
        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetStageResponse model) {
            super(model);
            this.accessLogSettings(model.accessLogSettings);
            this.clientCertificateId(model.clientCertificateId);
            this.createdDate(model.createdDate);
            this.defaultRouteSettings(model.defaultRouteSettings);
            this.deploymentId(model.deploymentId);
            this.description(model.description);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.routeSettings(model.routeSettings);
            this.stageName(model.stageName);
            this.stageVariables(model.stageVariables);
            this.tags(model.tags);
        }

        public final AccessLogSettings.Builder getAccessLogSettings() {
            return this.accessLogSettings != null ? this.accessLogSettings.toBuilder() : null;
        }

        @Override
        public final Builder accessLogSettings(AccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final void setAccessLogSettings(AccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final RouteSettings.Builder getDefaultRouteSettings() {
            return this.defaultRouteSettings != null ? this.defaultRouteSettings.toBuilder() : null;
        }

        @Override
        public final Builder defaultRouteSettings(RouteSettings defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        public final void setDefaultRouteSettings(RouteSettings.BuilderImpl defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings != null ? defaultRouteSettings.build() : null;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        public final Map<String, RouteSettings.Builder> getRouteSettings() {
            return this.routeSettings != null ? CollectionUtils.mapValues(this.routeSettings, RouteSettings::toBuilder) : null;
        }

        @Override
        public final Builder routeSettings(Map<String, RouteSettings> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copy(routeSettings);
            return this;
        }

        public final void setRouteSettings(Map<String, RouteSettings.BuilderImpl> routeSettings) {
            this.routeSettings = RouteSettingsMapCopier.copyFromBuilder(routeSettings);
        }

        public final String getStageName() {
            return this.stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        public final Map<String, String> getStageVariables() {
            return this.stageVariables;
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
            return this;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = StageVariablesMapCopier.copy(stageVariables);
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public GetStageResponse build() {
            return new GetStageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStageResponse> {
        public Builder accessLogSettings(AccessLogSettings var1);

        default public Builder accessLogSettings(Consumer<AccessLogSettings.Builder> accessLogSettings) {
            return this.accessLogSettings((AccessLogSettings)((AccessLogSettings.Builder)AccessLogSettings.builder().applyMutation(accessLogSettings)).build());
        }

        public Builder clientCertificateId(String var1);

        public Builder createdDate(Instant var1);

        public Builder defaultRouteSettings(RouteSettings var1);

        default public Builder defaultRouteSettings(Consumer<RouteSettings.Builder> defaultRouteSettings) {
            return this.defaultRouteSettings((RouteSettings)((RouteSettings.Builder)RouteSettings.builder().applyMutation(defaultRouteSettings)).build());
        }

        public Builder deploymentId(String var1);

        public Builder description(String var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder routeSettings(Map<String, RouteSettings> var1);

        public Builder stageName(String var1);

        public Builder stageVariables(Map<String, String> var1);

        public Builder tags(Map<String, String> var1);
    }
}

