/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IntegrationType {
    AWS("AWS"),
    HTTP("HTTP"),
    MOCK("MOCK"),
    HTTP_PROXY("HTTP_PROXY"),
    AWS_PROXY("AWS_PROXY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IntegrationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IntegrationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IntegrationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IntegrationType> knownValues() {
        return Stream.of(IntegrationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

