/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContentHandlingStrategy {
    CONVERT_TO_BINARY("CONVERT_TO_BINARY"),
    CONVERT_TO_TEXT("CONVERT_TO_TEXT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContentHandlingStrategy> VALUE_MAP;
    private final String value;

    private ContentHandlingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentHandlingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentHandlingStrategy> knownValues() {
        EnumSet<ContentHandlingStrategy> knownValues = EnumSet.allOf(ContentHandlingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContentHandlingStrategy.class, ContentHandlingStrategy::toString);
    }
}

