/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRouteRequestParameterRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, DeleteRouteRequestParameterRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApiId").getter(DeleteRouteRequestParameterRequest.getter(DeleteRouteRequestParameterRequest::apiId)).setter(DeleteRouteRequestParameterRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> REQUEST_PARAMETER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestParameterKey").getter(DeleteRouteRequestParameterRequest.getter(DeleteRouteRequestParameterRequest::requestParameterKey)).setter(DeleteRouteRequestParameterRequest.setter(Builder::requestParameterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("requestParameterKey").build()}).build();
    private static final SdkField<String> ROUTE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteId").getter(DeleteRouteRequestParameterRequest.getter(DeleteRouteRequestParameterRequest::routeId)).setter(DeleteRouteRequestParameterRequest.setter(Builder::routeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("routeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, REQUEST_PARAMETER_KEY_FIELD, ROUTE_ID_FIELD));
    private final String apiId;
    private final String requestParameterKey;
    private final String routeId;

    private DeleteRouteRequestParameterRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.requestParameterKey = builder.requestParameterKey;
        this.routeId = builder.routeId;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final String requestParameterKey() {
        return this.requestParameterKey;
    }

    public final String routeId() {
        return this.routeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRouteRequestParameterRequest)) {
            return false;
        }
        DeleteRouteRequestParameterRequest other = (DeleteRouteRequestParameterRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.requestParameterKey(), other.requestParameterKey()) && Objects.equals(this.routeId(), other.routeId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteRouteRequestParameterRequest").add("ApiId", (Object)this.apiId()).add("RequestParameterKey", (Object)this.requestParameterKey()).add("RouteId", (Object)this.routeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "RequestParameterKey": {
                return Optional.ofNullable(clazz.cast(this.requestParameterKey()));
            }
            case "RouteId": {
                return Optional.ofNullable(clazz.cast(this.routeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRouteRequestParameterRequest, T> g) {
        return obj -> g.apply((DeleteRouteRequestParameterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String requestParameterKey;
        private String routeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRouteRequestParameterRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.requestParameterKey(model.requestParameterKey);
            this.routeId(model.routeId);
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getRequestParameterKey() {
            return this.requestParameterKey;
        }

        public final void setRequestParameterKey(String requestParameterKey) {
            this.requestParameterKey = requestParameterKey;
        }

        @Override
        public final Builder requestParameterKey(String requestParameterKey) {
            this.requestParameterKey = requestParameterKey;
            return this;
        }

        public final String getRouteId() {
            return this.routeId;
        }

        public final void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public final Builder routeId(String routeId) {
            this.routeId = routeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRouteRequestParameterRequest build() {
            return new DeleteRouteRequestParameterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRouteRequestParameterRequest> {
        public Builder apiId(String var1);

        public Builder requestParameterKey(String var1);

        public Builder routeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

