/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MutualTlsAuthentication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MutualTlsAuthentication> {
    private static final SdkField<String> TRUSTSTORE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TruststoreUri").getter(MutualTlsAuthentication.getter(MutualTlsAuthentication::truststoreUri)).setter(MutualTlsAuthentication.setter(Builder::truststoreUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truststoreUri").build()}).build();
    private static final SdkField<String> TRUSTSTORE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TruststoreVersion").getter(MutualTlsAuthentication.getter(MutualTlsAuthentication::truststoreVersion)).setter(MutualTlsAuthentication.setter(Builder::truststoreVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truststoreVersion").build()}).build();
    private static final SdkField<List<String>> TRUSTSTORE_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TruststoreWarnings").getter(MutualTlsAuthentication.getter(MutualTlsAuthentication::truststoreWarnings)).setter(MutualTlsAuthentication.setter(Builder::truststoreWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("truststoreWarnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUSTSTORE_URI_FIELD, TRUSTSTORE_VERSION_FIELD, TRUSTSTORE_WARNINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String truststoreUri;
    private final String truststoreVersion;
    private final List<String> truststoreWarnings;

    private MutualTlsAuthentication(BuilderImpl builder) {
        this.truststoreUri = builder.truststoreUri;
        this.truststoreVersion = builder.truststoreVersion;
        this.truststoreWarnings = builder.truststoreWarnings;
    }

    public final String truststoreUri() {
        return this.truststoreUri;
    }

    public final String truststoreVersion() {
        return this.truststoreVersion;
    }

    public final boolean hasTruststoreWarnings() {
        return this.truststoreWarnings != null && !(this.truststoreWarnings instanceof SdkAutoConstructList);
    }

    public final List<String> truststoreWarnings() {
        return this.truststoreWarnings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.truststoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.truststoreVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruststoreWarnings() ? this.truststoreWarnings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutualTlsAuthentication)) {
            return false;
        }
        MutualTlsAuthentication other = (MutualTlsAuthentication)obj;
        return Objects.equals(this.truststoreUri(), other.truststoreUri()) && Objects.equals(this.truststoreVersion(), other.truststoreVersion()) && this.hasTruststoreWarnings() == other.hasTruststoreWarnings() && Objects.equals(this.truststoreWarnings(), other.truststoreWarnings());
    }

    public final String toString() {
        return ToString.builder((String)"MutualTlsAuthentication").add("TruststoreUri", (Object)this.truststoreUri()).add("TruststoreVersion", (Object)this.truststoreVersion()).add("TruststoreWarnings", this.hasTruststoreWarnings() ? this.truststoreWarnings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TruststoreUri": {
                return Optional.ofNullable(clazz.cast(this.truststoreUri()));
            }
            case "TruststoreVersion": {
                return Optional.ofNullable(clazz.cast(this.truststoreVersion()));
            }
            case "TruststoreWarnings": {
                return Optional.ofNullable(clazz.cast(this.truststoreWarnings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MutualTlsAuthentication, T> g) {
        return obj -> g.apply((MutualTlsAuthentication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String truststoreUri;
        private String truststoreVersion;
        private List<String> truststoreWarnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MutualTlsAuthentication model) {
            this.truststoreUri(model.truststoreUri);
            this.truststoreVersion(model.truststoreVersion);
            this.truststoreWarnings(model.truststoreWarnings);
        }

        public final String getTruststoreUri() {
            return this.truststoreUri;
        }

        public final void setTruststoreUri(String truststoreUri) {
            this.truststoreUri = truststoreUri;
        }

        @Override
        @Transient
        public final Builder truststoreUri(String truststoreUri) {
            this.truststoreUri = truststoreUri;
            return this;
        }

        public final String getTruststoreVersion() {
            return this.truststoreVersion;
        }

        public final void setTruststoreVersion(String truststoreVersion) {
            this.truststoreVersion = truststoreVersion;
        }

        @Override
        @Transient
        public final Builder truststoreVersion(String truststoreVersion) {
            this.truststoreVersion = truststoreVersion;
            return this;
        }

        public final Collection<String> getTruststoreWarnings() {
            if (this.truststoreWarnings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.truststoreWarnings;
        }

        public final void setTruststoreWarnings(Collection<String> truststoreWarnings) {
            this.truststoreWarnings = ___listOf__stringCopier.copy(truststoreWarnings);
        }

        @Override
        @Transient
        public final Builder truststoreWarnings(Collection<String> truststoreWarnings) {
            this.truststoreWarnings = ___listOf__stringCopier.copy(truststoreWarnings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder truststoreWarnings(String ... truststoreWarnings) {
            this.truststoreWarnings(Arrays.asList(truststoreWarnings));
            return this;
        }

        public MutualTlsAuthentication build() {
            return new MutualTlsAuthentication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MutualTlsAuthentication> {
        public Builder truststoreUri(String var1);

        public Builder truststoreVersion(String var1);

        public Builder truststoreWarnings(Collection<String> var1);

        public Builder truststoreWarnings(String ... var1);
    }
}

