/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigatewayv2.model.CorsHeaderListCopier;
import software.amazon.awssdk.services.apigatewayv2.model.CorsMethodListCopier;
import software.amazon.awssdk.services.apigatewayv2.model.CorsOriginListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cors
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cors> {
    private static final SdkField<Boolean> ALLOW_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowCredentials").getter(Cors.getter(Cors::allowCredentials)).setter(Cors.setter(Builder::allowCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowCredentials").build()}).build();
    private static final SdkField<List<String>> ALLOW_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowHeaders").getter(Cors.getter(Cors::allowHeaders)).setter(Cors.setter(Builder::allowHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOW_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowMethods").getter(Cors.getter(Cors::allowMethods)).setter(Cors.setter(Builder::allowMethods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOW_ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowOrigins").getter(Cors.getter(Cors::allowOrigins)).setter(Cors.setter(Builder::allowOrigins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowOrigins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExposeHeaders").getter(Cors.getter(Cors::exposeHeaders)).setter(Cors.setter(Builder::exposeHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exposeHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_AGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAge").getter(Cors.getter(Cors::maxAge)).setter(Cors.setter(Builder::maxAge)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAge").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_CREDENTIALS_FIELD, ALLOW_HEADERS_FIELD, ALLOW_METHODS_FIELD, ALLOW_ORIGINS_FIELD, EXPOSE_HEADERS_FIELD, MAX_AGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean allowCredentials;
    private final List<String> allowHeaders;
    private final List<String> allowMethods;
    private final List<String> allowOrigins;
    private final List<String> exposeHeaders;
    private final Integer maxAge;

    private Cors(BuilderImpl builder) {
        this.allowCredentials = builder.allowCredentials;
        this.allowHeaders = builder.allowHeaders;
        this.allowMethods = builder.allowMethods;
        this.allowOrigins = builder.allowOrigins;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAge = builder.maxAge;
    }

    public final Boolean allowCredentials() {
        return this.allowCredentials;
    }

    public final boolean hasAllowHeaders() {
        return this.allowHeaders != null && !(this.allowHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> allowHeaders() {
        return this.allowHeaders;
    }

    public final boolean hasAllowMethods() {
        return this.allowMethods != null && !(this.allowMethods instanceof SdkAutoConstructList);
    }

    public final List<String> allowMethods() {
        return this.allowMethods;
    }

    public final boolean hasAllowOrigins() {
        return this.allowOrigins != null && !(this.allowOrigins instanceof SdkAutoConstructList);
    }

    public final List<String> allowOrigins() {
        return this.allowOrigins;
    }

    public final boolean hasExposeHeaders() {
        return this.exposeHeaders != null && !(this.exposeHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> exposeHeaders() {
        return this.exposeHeaders;
    }

    public final Integer maxAge() {
        return this.maxAge;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowHeaders() ? this.allowHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowMethods() ? this.allowMethods() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowOrigins() ? this.allowOrigins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExposeHeaders() ? this.exposeHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAge());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cors)) {
            return false;
        }
        Cors other = (Cors)obj;
        return Objects.equals(this.allowCredentials(), other.allowCredentials()) && this.hasAllowHeaders() == other.hasAllowHeaders() && Objects.equals(this.allowHeaders(), other.allowHeaders()) && this.hasAllowMethods() == other.hasAllowMethods() && Objects.equals(this.allowMethods(), other.allowMethods()) && this.hasAllowOrigins() == other.hasAllowOrigins() && Objects.equals(this.allowOrigins(), other.allowOrigins()) && this.hasExposeHeaders() == other.hasExposeHeaders() && Objects.equals(this.exposeHeaders(), other.exposeHeaders()) && Objects.equals(this.maxAge(), other.maxAge());
    }

    public final String toString() {
        return ToString.builder((String)"Cors").add("AllowCredentials", (Object)this.allowCredentials()).add("AllowHeaders", this.hasAllowHeaders() ? this.allowHeaders() : null).add("AllowMethods", this.hasAllowMethods() ? this.allowMethods() : null).add("AllowOrigins", this.hasAllowOrigins() ? this.allowOrigins() : null).add("ExposeHeaders", this.hasExposeHeaders() ? this.exposeHeaders() : null).add("MaxAge", (Object)this.maxAge()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowCredentials": {
                return Optional.ofNullable(clazz.cast(this.allowCredentials()));
            }
            case "AllowHeaders": {
                return Optional.ofNullable(clazz.cast(this.allowHeaders()));
            }
            case "AllowMethods": {
                return Optional.ofNullable(clazz.cast(this.allowMethods()));
            }
            case "AllowOrigins": {
                return Optional.ofNullable(clazz.cast(this.allowOrigins()));
            }
            case "ExposeHeaders": {
                return Optional.ofNullable(clazz.cast(this.exposeHeaders()));
            }
            case "MaxAge": {
                return Optional.ofNullable(clazz.cast(this.maxAge()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cors, T> g) {
        return obj -> g.apply((Cors)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowCredentials;
        private List<String> allowHeaders = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowMethods = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowOrigins = DefaultSdkAutoConstructList.getInstance();
        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();
        private Integer maxAge;

        private BuilderImpl() {
        }

        private BuilderImpl(Cors model) {
            this.allowCredentials(model.allowCredentials);
            this.allowHeaders(model.allowHeaders);
            this.allowMethods(model.allowMethods);
            this.allowOrigins(model.allowOrigins);
            this.exposeHeaders(model.exposeHeaders);
            this.maxAge(model.maxAge);
        }

        public final Boolean getAllowCredentials() {
            return this.allowCredentials;
        }

        public final void setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        @Override
        @Transient
        public final Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public final Collection<String> getAllowHeaders() {
            if (this.allowHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowHeaders;
        }

        public final void setAllowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = CorsHeaderListCopier.copy(allowHeaders);
        }

        @Override
        @Transient
        public final Builder allowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = CorsHeaderListCopier.copy(allowHeaders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowHeaders(String ... allowHeaders) {
            this.allowHeaders(Arrays.asList(allowHeaders));
            return this;
        }

        public final Collection<String> getAllowMethods() {
            if (this.allowMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowMethods;
        }

        public final void setAllowMethods(Collection<String> allowMethods) {
            this.allowMethods = CorsMethodListCopier.copy(allowMethods);
        }

        @Override
        @Transient
        public final Builder allowMethods(Collection<String> allowMethods) {
            this.allowMethods = CorsMethodListCopier.copy(allowMethods);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowMethods(String ... allowMethods) {
            this.allowMethods(Arrays.asList(allowMethods));
            return this;
        }

        public final Collection<String> getAllowOrigins() {
            if (this.allowOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowOrigins;
        }

        public final void setAllowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = CorsOriginListCopier.copy(allowOrigins);
        }

        @Override
        @Transient
        public final Builder allowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = CorsOriginListCopier.copy(allowOrigins);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder allowOrigins(String ... allowOrigins) {
            this.allowOrigins(Arrays.asList(allowOrigins));
            return this;
        }

        public final Collection<String> getExposeHeaders() {
            if (this.exposeHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exposeHeaders;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = CorsHeaderListCopier.copy(exposeHeaders);
        }

        @Override
        @Transient
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = CorsHeaderListCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder exposeHeaders(String ... exposeHeaders) {
            this.exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final Integer getMaxAge() {
            return this.maxAge;
        }

        public final void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }

        @Override
        @Transient
        public final Builder maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Cors build() {
            return new Cors(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cors> {
        public Builder allowCredentials(Boolean var1);

        public Builder allowHeaders(Collection<String> var1);

        public Builder allowHeaders(String ... var1);

        public Builder allowMethods(Collection<String> var1);

        public Builder allowMethods(String ... var1);

        public Builder allowOrigins(Collection<String> var1);

        public Builder allowOrigins(String ... var1);

        public Builder exposeHeaders(Collection<String> var1);

        public Builder exposeHeaders(String ... var1);

        public Builder maxAge(Integer var1);
    }
}

