/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRouteResponseResponse extends ApiGatewayV2Response implements
        ToCopyableBuilder<GetRouteResponseResponse.Builder, GetRouteResponseResponse> {
    private static final SdkField<String> MODEL_SELECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelSelectionExpression").getter(getter(GetRouteResponseResponse::modelSelectionExpression))
            .setter(setter(Builder::modelSelectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSelectionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> RESPONSE_MODELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ResponseModels")
            .getter(getter(GetRouteResponseResponse::responseModels))
            .setter(setter(Builder::responseModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ParameterConstraints>> RESPONSE_PARAMETERS_FIELD = SdkField
            .<Map<String, ParameterConstraints>> builder(MarshallingType.MAP)
            .memberName("ResponseParameters")
            .getter(getter(GetRouteResponseResponse::responseParameters))
            .setter(setter(Builder::responseParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ParameterConstraints> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterConstraints::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_RESPONSE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteResponseId").getter(getter(GetRouteResponseResponse::routeResponseId))
            .setter(setter(Builder::routeResponseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseId").build()).build();

    private static final SdkField<String> ROUTE_RESPONSE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteResponseKey").getter(getter(GetRouteResponseResponse::routeResponseKey))
            .setter(setter(Builder::routeResponseKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeResponseKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_SELECTION_EXPRESSION_FIELD, RESPONSE_MODELS_FIELD, RESPONSE_PARAMETERS_FIELD, ROUTE_RESPONSE_ID_FIELD,
            ROUTE_RESPONSE_KEY_FIELD));

    private final String modelSelectionExpression;

    private final Map<String, String> responseModels;

    private final Map<String, ParameterConstraints> responseParameters;

    private final String routeResponseId;

    private final String routeResponseKey;

    private GetRouteResponseResponse(BuilderImpl builder) {
        super(builder);
        this.modelSelectionExpression = builder.modelSelectionExpression;
        this.responseModels = builder.responseModels;
        this.responseParameters = builder.responseParameters;
        this.routeResponseId = builder.routeResponseId;
        this.routeResponseKey = builder.routeResponseKey;
    }

    /**
     * <p>
     * Represents the model selection expression of a route response. Supported only for WebSocket APIs.
     * </p>
     * 
     * @return Represents the model selection expression of a route response. Supported only for WebSocket APIs.
     */
    public final String modelSelectionExpression() {
        return modelSelectionExpression;
    }

    /**
     * Returns true if the ResponseModels property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResponseModels() {
        return responseModels != null && !(responseModels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents the response models of a route response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseModels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents the response models of a route response.
     */
    public final Map<String, String> responseModels() {
        return responseModels;
    }

    /**
     * Returns true if the ResponseParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResponseParameters() {
        return responseParameters != null && !(responseParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Represents the response parameters of a route response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResponseParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents the response parameters of a route response.
     */
    public final Map<String, ParameterConstraints> responseParameters() {
        return responseParameters;
    }

    /**
     * <p>
     * Represents the identifier of a route response.
     * </p>
     * 
     * @return Represents the identifier of a route response.
     */
    public final String routeResponseId() {
        return routeResponseId;
    }

    /**
     * <p>
     * Represents the route response key of a route response.
     * </p>
     * 
     * @return Represents the route response key of a route response.
     */
    public final String routeResponseKey() {
        return routeResponseKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelSelectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseModels() ? responseModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResponseParameters() ? responseParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeResponseId());
        hashCode = 31 * hashCode + Objects.hashCode(routeResponseKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRouteResponseResponse)) {
            return false;
        }
        GetRouteResponseResponse other = (GetRouteResponseResponse) obj;
        return Objects.equals(modelSelectionExpression(), other.modelSelectionExpression())
                && hasResponseModels() == other.hasResponseModels() && Objects.equals(responseModels(), other.responseModels())
                && hasResponseParameters() == other.hasResponseParameters()
                && Objects.equals(responseParameters(), other.responseParameters())
                && Objects.equals(routeResponseId(), other.routeResponseId())
                && Objects.equals(routeResponseKey(), other.routeResponseKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRouteResponseResponse").add("ModelSelectionExpression", modelSelectionExpression())
                .add("ResponseModels", hasResponseModels() ? responseModels() : null)
                .add("ResponseParameters", hasResponseParameters() ? responseParameters() : null)
                .add("RouteResponseId", routeResponseId()).add("RouteResponseKey", routeResponseKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelSelectionExpression":
            return Optional.ofNullable(clazz.cast(modelSelectionExpression()));
        case "ResponseModels":
            return Optional.ofNullable(clazz.cast(responseModels()));
        case "ResponseParameters":
            return Optional.ofNullable(clazz.cast(responseParameters()));
        case "RouteResponseId":
            return Optional.ofNullable(clazz.cast(routeResponseId()));
        case "RouteResponseKey":
            return Optional.ofNullable(clazz.cast(routeResponseKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRouteResponseResponse, T> g) {
        return obj -> g.apply((GetRouteResponseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetRouteResponseResponse> {
        /**
         * <p>
         * Represents the model selection expression of a route response. Supported only for WebSocket APIs.
         * </p>
         * 
         * @param modelSelectionExpression
         *        Represents the model selection expression of a route response. Supported only for WebSocket APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSelectionExpression(String modelSelectionExpression);

        /**
         * <p>
         * Represents the response models of a route response.
         * </p>
         * 
         * @param responseModels
         *        Represents the response models of a route response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseModels(Map<String, String> responseModels);

        /**
         * <p>
         * Represents the response parameters of a route response.
         * </p>
         * 
         * @param responseParameters
         *        Represents the response parameters of a route response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseParameters(Map<String, ParameterConstraints> responseParameters);

        /**
         * <p>
         * Represents the identifier of a route response.
         * </p>
         * 
         * @param routeResponseId
         *        Represents the identifier of a route response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeResponseId(String routeResponseId);

        /**
         * <p>
         * Represents the route response key of a route response.
         * </p>
         * 
         * @param routeResponseKey
         *        Represents the route response key of a route response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeResponseKey(String routeResponseKey);
    }

    static final class BuilderImpl extends ApiGatewayV2Response.BuilderImpl implements Builder {
        private String modelSelectionExpression;

        private Map<String, String> responseModels = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ParameterConstraints> responseParameters = DefaultSdkAutoConstructMap.getInstance();

        private String routeResponseId;

        private String routeResponseKey;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRouteResponseResponse model) {
            super(model);
            modelSelectionExpression(model.modelSelectionExpression);
            responseModels(model.responseModels);
            responseParameters(model.responseParameters);
            routeResponseId(model.routeResponseId);
            routeResponseKey(model.routeResponseKey);
        }

        public final String getModelSelectionExpression() {
            return modelSelectionExpression;
        }

        @Override
        public final Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public final void setModelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
        }

        public final Map<String, String> getResponseModels() {
            if (responseModels instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseModels;
        }

        @Override
        public final Builder responseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
            return this;
        }

        public final void setResponseModels(Map<String, String> responseModels) {
            this.responseModels = RouteModelsCopier.copy(responseModels);
        }

        public final Map<String, ParameterConstraints.Builder> getResponseParameters() {
            if (responseParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return responseParameters != null ? CollectionUtils.mapValues(responseParameters, ParameterConstraints::toBuilder)
                    : null;
        }

        @Override
        public final Builder responseParameters(Map<String, ParameterConstraints> responseParameters) {
            this.responseParameters = RouteParametersCopier.copy(responseParameters);
            return this;
        }

        public final void setResponseParameters(Map<String, ParameterConstraints.BuilderImpl> responseParameters) {
            this.responseParameters = RouteParametersCopier.copyFromBuilder(responseParameters);
        }

        public final String getRouteResponseId() {
            return routeResponseId;
        }

        @Override
        public final Builder routeResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
            return this;
        }

        public final void setRouteResponseId(String routeResponseId) {
            this.routeResponseId = routeResponseId;
        }

        public final String getRouteResponseKey() {
            return routeResponseKey;
        }

        @Override
        public final Builder routeResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
            return this;
        }

        public final void setRouteResponseKey(String routeResponseKey) {
            this.routeResponseKey = routeResponseKey;
        }

        @Override
        public GetRouteResponseResponse build() {
            return new GetRouteResponseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
