/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReimportApiRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, ReimportApiRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReimportApiRequest.getter(ReimportApiRequest::apiId)).setter(ReimportApiRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> BASEPATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReimportApiRequest.getter(ReimportApiRequest::basepath)).setter(ReimportApiRequest.setter(Builder::basepath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("basepath").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReimportApiRequest.getter(ReimportApiRequest::body)).setter(ReimportApiRequest.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<Boolean> FAIL_ON_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ReimportApiRequest.getter(ReimportApiRequest::failOnWarnings)).setter(ReimportApiRequest.setter(Builder::failOnWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("failOnWarnings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, BASEPATH_FIELD, BODY_FIELD, FAIL_ON_WARNINGS_FIELD));
    private final String apiId;
    private final String basepath;
    private final String body;
    private final Boolean failOnWarnings;

    private ReimportApiRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.basepath = builder.basepath;
        this.body = builder.body;
        this.failOnWarnings = builder.failOnWarnings;
    }

    public String apiId() {
        return this.apiId;
    }

    public String basepath() {
        return this.basepath;
    }

    public String body() {
        return this.body;
    }

    public Boolean failOnWarnings() {
        return this.failOnWarnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.basepath());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.failOnWarnings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReimportApiRequest)) {
            return false;
        }
        ReimportApiRequest other = (ReimportApiRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.basepath(), other.basepath()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.failOnWarnings(), other.failOnWarnings());
    }

    public String toString() {
        return ToString.builder((String)"ReimportApiRequest").add("ApiId", (Object)this.apiId()).add("Basepath", (Object)this.basepath()).add("Body", (Object)this.body()).add("FailOnWarnings", (Object)this.failOnWarnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "Basepath": {
                return Optional.ofNullable(clazz.cast(this.basepath()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "FailOnWarnings": {
                return Optional.ofNullable(clazz.cast(this.failOnWarnings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReimportApiRequest, T> g) {
        return obj -> g.apply((ReimportApiRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String basepath;
        private String body;
        private Boolean failOnWarnings;

        private BuilderImpl() {
        }

        private BuilderImpl(ReimportApiRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.basepath(model.basepath);
            this.body(model.body);
            this.failOnWarnings(model.failOnWarnings);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getBasepath() {
            return this.basepath;
        }

        @Override
        public final Builder basepath(String basepath) {
            this.basepath = basepath;
            return this;
        }

        public final void setBasepath(String basepath) {
            this.basepath = basepath;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Boolean getFailOnWarnings() {
            return this.failOnWarnings;
        }

        @Override
        public final Builder failOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
            return this;
        }

        public final void setFailOnWarnings(Boolean failOnWarnings) {
            this.failOnWarnings = failOnWarnings;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReimportApiRequest build() {
            return new ReimportApiRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReimportApiRequest> {
        public Builder apiId(String var1);

        public Builder basepath(String var1);

        public Builder body(String var1);

        public Builder failOnWarnings(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

