/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewaymanagementapi.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.ApiGatewayManagementApiResponse;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.Identity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionResponse
extends ApiGatewayManagementApiResponse
implements ToCopyableBuilder<Builder, GetConnectionResponse> {
    private static final SdkField<Instant> CONNECTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConnectedAt").getter(GetConnectionResponse.getter(GetConnectionResponse::connectedAt)).setter(GetConnectionResponse.setter(Builder::connectedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Identity> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Identity").getter(GetConnectionResponse.getter(GetConnectionResponse::identity)).setter(GetConnectionResponse.setter(Builder::identity)).constructor(Identity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identity").build()}).build();
    private static final SdkField<Instant> LAST_ACTIVE_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastActiveAt").getter(GetConnectionResponse.getter(GetConnectionResponse::lastActiveAt)).setter(GetConnectionResponse.setter(Builder::lastActiveAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastActiveAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTED_AT_FIELD, IDENTITY_FIELD, LAST_ACTIVE_AT_FIELD));
    private final Instant connectedAt;
    private final Identity identity;
    private final Instant lastActiveAt;

    private GetConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectedAt = builder.connectedAt;
        this.identity = builder.identity;
        this.lastActiveAt = builder.lastActiveAt;
    }

    public final Instant connectedAt() {
        return this.connectedAt;
    }

    public final Identity identity() {
        return this.identity;
    }

    public final Instant lastActiveAt() {
        return this.lastActiveAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastActiveAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionResponse)) {
            return false;
        }
        GetConnectionResponse other = (GetConnectionResponse)((Object)obj);
        return Objects.equals(this.connectedAt(), other.connectedAt()) && Objects.equals(this.identity(), other.identity()) && Objects.equals(this.lastActiveAt(), other.lastActiveAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionResponse").add("ConnectedAt", (Object)this.connectedAt()).add("Identity", (Object)this.identity()).add("LastActiveAt", (Object)this.lastActiveAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectedAt": {
                return Optional.ofNullable(clazz.cast(this.connectedAt()));
            }
            case "Identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "LastActiveAt": {
                return Optional.ofNullable(clazz.cast(this.lastActiveAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionResponse, T> g) {
        return obj -> g.apply((GetConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayManagementApiResponse.BuilderImpl
    implements Builder {
        private Instant connectedAt;
        private Identity identity;
        private Instant lastActiveAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionResponse model) {
            super(model);
            this.connectedAt(model.connectedAt);
            this.identity(model.identity);
            this.lastActiveAt(model.lastActiveAt);
        }

        public final Instant getConnectedAt() {
            return this.connectedAt;
        }

        @Override
        public final Builder connectedAt(Instant connectedAt) {
            this.connectedAt = connectedAt;
            return this;
        }

        public final void setConnectedAt(Instant connectedAt) {
            this.connectedAt = connectedAt;
        }

        public final Identity.Builder getIdentity() {
            return this.identity != null ? this.identity.toBuilder() : null;
        }

        @Override
        public final Builder identity(Identity identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(Identity.BuilderImpl identity) {
            this.identity = identity != null ? identity.build() : null;
        }

        public final Instant getLastActiveAt() {
            return this.lastActiveAt;
        }

        @Override
        public final Builder lastActiveAt(Instant lastActiveAt) {
            this.lastActiveAt = lastActiveAt;
            return this;
        }

        public final void setLastActiveAt(Instant lastActiveAt) {
            this.lastActiveAt = lastActiveAt;
        }

        @Override
        public GetConnectionResponse build() {
            return new GetConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayManagementApiResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionResponse> {
        public Builder connectedAt(Instant var1);

        public Builder identity(Identity var1);

        default public Builder identity(Consumer<Identity.Builder> identity) {
            return this.identity((Identity)((Identity.Builder)Identity.builder().applyMutation(identity)).build());
        }

        public Builder lastActiveAt(Instant var1);
    }
}

