/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfPatchOperationCopier;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBasePathMappingRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, UpdateBasePathMappingRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateBasePathMappingRequest.getter(UpdateBasePathMappingRequest::domainName)).setter(UpdateBasePathMappingRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domain_name").build()}).build();
    private static final SdkField<String> BASE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateBasePathMappingRequest.getter(UpdateBasePathMappingRequest::basePath)).setter(UpdateBasePathMappingRequest.setter(Builder::basePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("base_path").build()}).build();
    private static final SdkField<List<PatchOperation>> PATCH_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateBasePathMappingRequest.getter(UpdateBasePathMappingRequest::patchOperations)).setter(UpdateBasePathMappingRequest.setter(Builder::patchOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, BASE_PATH_FIELD, PATCH_OPERATIONS_FIELD));
    private final String domainName;
    private final String basePath;
    private final List<PatchOperation> patchOperations;

    private UpdateBasePathMappingRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.basePath = builder.basePath;
        this.patchOperations = builder.patchOperations;
    }

    public String domainName() {
        return this.domainName;
    }

    public String basePath() {
        return this.basePath;
    }

    public List<PatchOperation> patchOperations() {
        return this.patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.basePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchOperations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBasePathMappingRequest)) {
            return false;
        }
        UpdateBasePathMappingRequest other = (UpdateBasePathMappingRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.basePath(), other.basePath()) && Objects.equals(this.patchOperations(), other.patchOperations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateBasePathMappingRequest").add("DomainName", (Object)this.domainName()).add("BasePath", (Object)this.basePath()).add("PatchOperations", this.patchOperations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "basePath": {
                return Optional.ofNullable(clazz.cast(this.basePath()));
            }
            case "patchOperations": {
                return Optional.ofNullable(clazz.cast(this.patchOperations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBasePathMappingRequest, T> g) {
        return obj -> g.apply((UpdateBasePathMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String basePath;
        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBasePathMappingRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.basePath(model.basePath);
            this.patchOperations(model.patchOperations);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getBasePath() {
            return this.basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public final Collection<PatchOperation.Builder> getPatchOperations() {
            return this.patchOperations != null ? (Collection)this.patchOperations.stream().map(PatchOperation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation ... patchOperations) {
            this.patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder> ... patchOperations) {
            this.patchOperations(Stream.of(patchOperations).map(c -> (PatchOperation)((PatchOperation.Builder)PatchOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBasePathMappingRequest build() {
            return new UpdateBasePathMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBasePathMappingRequest> {
        public Builder domainName(String var1);

        public Builder basePath(String var1);

        public Builder patchOperations(Collection<PatchOperation> var1);

        public Builder patchOperations(PatchOperation ... var1);

        public Builder patchOperations(Consumer<PatchOperation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

