/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BasePathMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BasePathMapping> {
    private static final SdkField<String> BASE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BasePathMapping.getter(BasePathMapping::basePath)).setter(BasePathMapping.setter(Builder::basePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basePath").build()}).build();
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BasePathMapping.getter(BasePathMapping::restApiId)).setter(BasePathMapping.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restApiId").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BasePathMapping.getter(BasePathMapping::stage)).setter(BasePathMapping.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_PATH_FIELD, REST_API_ID_FIELD, STAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String basePath;
    private final String restApiId;
    private final String stage;

    private BasePathMapping(BuilderImpl builder) {
        this.basePath = builder.basePath;
        this.restApiId = builder.restApiId;
        this.stage = builder.stage;
    }

    public String basePath() {
        return this.basePath;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String stage() {
        return this.stage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.basePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BasePathMapping)) {
            return false;
        }
        BasePathMapping other = (BasePathMapping)obj;
        return Objects.equals(this.basePath(), other.basePath()) && Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.stage(), other.stage());
    }

    public String toString() {
        return ToString.builder((String)"BasePathMapping").add("BasePath", (Object)this.basePath()).add("RestApiId", (Object)this.restApiId()).add("Stage", (Object)this.stage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "basePath": {
                return Optional.ofNullable(clazz.cast(this.basePath()));
            }
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "stage": {
                return Optional.ofNullable(clazz.cast(this.stage()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BasePathMapping, T> g) {
        return obj -> g.apply((BasePathMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String basePath;
        private String restApiId;
        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(BasePathMapping model) {
            this.basePath(model.basePath);
            this.restApiId(model.restApiId);
            this.stage(model.stage);
        }

        public final String getBasePath() {
            return this.basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getStage() {
            return this.stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        public BasePathMapping build() {
            return new BasePathMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BasePathMapping> {
        public Builder basePath(String var1);

        public Builder restApiId(String var1);

        public Builder stage(String var1);
    }
}

