/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DomainNameStatus {
    AVAILABLE("AVAILABLE"),
    UPDATING("UPDATING"),
    PENDING("PENDING"),
    PENDING_CERTIFICATE_REIMPORT("PENDING_CERTIFICATE_REIMPORT"),
    PENDING_OWNERSHIP_VERIFICATION("PENDING_OWNERSHIP_VERIFICATION"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DomainNameStatus> VALUE_MAP;
    private final String value;

    private DomainNameStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DomainNameStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DomainNameStatus> knownValues() {
        EnumSet<DomainNameStatus> knownValues = EnumSet.allOf(DomainNameStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DomainNameStatus.class, DomainNameStatus::toString);
    }
}

