/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ListOfSdkConfigurationPropertyCopier;
import software.amazon.awssdk.services.apigateway.model.SdkConfigurationProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SdkType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SdkType> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SdkType.getter(SdkType::id)).setter(SdkType.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> FRIENDLY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("friendlyName").getter(SdkType.getter(SdkType::friendlyName)).setter(SdkType.setter(Builder::friendlyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("friendlyName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SdkType.getter(SdkType::description)).setter(SdkType.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SdkConfigurationProperty>> CONFIGURATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurationProperties").getter(SdkType.getter(SdkType::configurationProperties)).setter(SdkType.setter(Builder::configurationProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SdkConfigurationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FRIENDLY_NAME_FIELD, DESCRIPTION_FIELD, CONFIGURATION_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SdkType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String friendlyName;
    private final String description;
    private final List<SdkConfigurationProperty> configurationProperties;

    private SdkType(BuilderImpl builder) {
        this.id = builder.id;
        this.friendlyName = builder.friendlyName;
        this.description = builder.description;
        this.configurationProperties = builder.configurationProperties;
    }

    public final String id() {
        return this.id;
    }

    public final String friendlyName() {
        return this.friendlyName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasConfigurationProperties() {
        return this.configurationProperties != null && !(this.configurationProperties instanceof SdkAutoConstructList);
    }

    public final List<SdkConfigurationProperty> configurationProperties() {
        return this.configurationProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.friendlyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationProperties() ? this.configurationProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkType)) {
            return false;
        }
        SdkType other = (SdkType)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.friendlyName(), other.friendlyName()) && Objects.equals(this.description(), other.description()) && this.hasConfigurationProperties() == other.hasConfigurationProperties() && Objects.equals(this.configurationProperties(), other.configurationProperties());
    }

    public final String toString() {
        return ToString.builder((String)"SdkType").add("Id", (Object)this.id()).add("FriendlyName", (Object)this.friendlyName()).add("Description", (Object)this.description()).add("ConfigurationProperties", this.hasConfigurationProperties() ? this.configurationProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "friendlyName": {
                return Optional.ofNullable(clazz.cast(this.friendlyName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "configurationProperties": {
                return Optional.ofNullable(clazz.cast(this.configurationProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("friendlyName", FRIENDLY_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("configurationProperties", CONFIGURATION_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SdkType, T> g) {
        return obj -> g.apply((SdkType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String friendlyName;
        private String description;
        private List<SdkConfigurationProperty> configurationProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SdkType model) {
            this.id(model.id);
            this.friendlyName(model.friendlyName);
            this.description(model.description);
            this.configurationProperties(model.configurationProperties);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFriendlyName() {
            return this.friendlyName;
        }

        public final void setFriendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        @Override
        public final Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SdkConfigurationProperty.Builder> getConfigurationProperties() {
            List<SdkConfigurationProperty.Builder> result = ListOfSdkConfigurationPropertyCopier.copyToBuilder(this.configurationProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationProperties(Collection<SdkConfigurationProperty.BuilderImpl> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copyFromBuilder(configurationProperties);
        }

        @Override
        public final Builder configurationProperties(Collection<SdkConfigurationProperty> configurationProperties) {
            this.configurationProperties = ListOfSdkConfigurationPropertyCopier.copy(configurationProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(SdkConfigurationProperty ... configurationProperties) {
            this.configurationProperties(Arrays.asList(configurationProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder> ... configurationProperties) {
            this.configurationProperties(Stream.of(configurationProperties).map(c -> (SdkConfigurationProperty)((SdkConfigurationProperty.Builder)SdkConfigurationProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SdkType build() {
            return new SdkType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SdkType> {
        public Builder id(String var1);

        public Builder friendlyName(String var1);

        public Builder description(String var1);

        public Builder configurationProperties(Collection<SdkConfigurationProperty> var1);

        public Builder configurationProperties(SdkConfigurationProperty ... var1);

        public Builder configurationProperties(Consumer<SdkConfigurationProperty.Builder> ... var1);
    }
}

