/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointAccessMode {
    BASIC("BASIC"),
    STRICT("STRICT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointAccessMode> VALUE_MAP;
    private final String value;

    private EndpointAccessMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointAccessMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointAccessMode> knownValues() {
        EnumSet<EndpointAccessMode> knownValues = EnumSet.allOf(EndpointAccessMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointAccessMode.class, EndpointAccessMode::toString);
    }
}

