/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.Integration;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfMethodResponseCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToBooleanCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.MethodResponse;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMethodResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateMethodResponse> {
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMethodResponse.getter(UpdateMethodResponse::httpMethod)).setter(UpdateMethodResponse.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()}).build();
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMethodResponse.getter(UpdateMethodResponse::authorizationType)).setter(UpdateMethodResponse.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()}).build();
    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMethodResponse.getter(UpdateMethodResponse::authorizerId)).setter(UpdateMethodResponse.setter(Builder::authorizerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerId").build()}).build();
    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateMethodResponse.getter(UpdateMethodResponse::apiKeyRequired)).setter(UpdateMethodResponse.setter(Builder::apiKeyRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()}).build();
    private static final SdkField<String> REQUEST_VALIDATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMethodResponse.getter(UpdateMethodResponse::requestValidatorId)).setter(UpdateMethodResponse.setter(Builder::requestValidatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestValidatorId").build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMethodResponse.getter(UpdateMethodResponse::operationName)).setter(UpdateMethodResponse.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()}).build();
    private static final SdkField<Map<String, Boolean>> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateMethodResponse.getter(UpdateMethodResponse::requestParameters)).setter(UpdateMethodResponse.setter(Builder::requestParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateMethodResponse.getter(UpdateMethodResponse::requestModels)).setter(UpdateMethodResponse.setter(Builder::requestModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, MethodResponse>> METHOD_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateMethodResponse.getter(UpdateMethodResponse::methodResponses)).setter(UpdateMethodResponse.setter(Builder::methodResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodResponses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MethodResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integration> METHOD_INTEGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateMethodResponse.getter(UpdateMethodResponse::methodIntegration)).setter(UpdateMethodResponse.setter(Builder::methodIntegration)).constructor(Integration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodIntegration").build()}).build();
    private static final SdkField<List<String>> AUTHORIZATION_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateMethodResponse.getter(UpdateMethodResponse::authorizationScopes)).setter(UpdateMethodResponse.setter(Builder::authorizationScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_METHOD_FIELD, AUTHORIZATION_TYPE_FIELD, AUTHORIZER_ID_FIELD, API_KEY_REQUIRED_FIELD, REQUEST_VALIDATOR_ID_FIELD, OPERATION_NAME_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_MODELS_FIELD, METHOD_RESPONSES_FIELD, METHOD_INTEGRATION_FIELD, AUTHORIZATION_SCOPES_FIELD));
    private final String httpMethod;
    private final String authorizationType;
    private final String authorizerId;
    private final Boolean apiKeyRequired;
    private final String requestValidatorId;
    private final String operationName;
    private final Map<String, Boolean> requestParameters;
    private final Map<String, String> requestModels;
    private final Map<String, MethodResponse> methodResponses;
    private final Integration methodIntegration;
    private final List<String> authorizationScopes;

    private UpdateMethodResponse(BuilderImpl builder) {
        super(builder);
        this.httpMethod = builder.httpMethod;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.apiKeyRequired = builder.apiKeyRequired;
        this.requestValidatorId = builder.requestValidatorId;
        this.operationName = builder.operationName;
        this.requestParameters = builder.requestParameters;
        this.requestModels = builder.requestModels;
        this.methodResponses = builder.methodResponses;
        this.methodIntegration = builder.methodIntegration;
        this.authorizationScopes = builder.authorizationScopes;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String authorizationType() {
        return this.authorizationType;
    }

    public String authorizerId() {
        return this.authorizerId;
    }

    public Boolean apiKeyRequired() {
        return this.apiKeyRequired;
    }

    public String requestValidatorId() {
        return this.requestValidatorId;
    }

    public String operationName() {
        return this.operationName;
    }

    public Map<String, Boolean> requestParameters() {
        return this.requestParameters;
    }

    public Map<String, String> requestModels() {
        return this.requestModels;
    }

    public Map<String, MethodResponse> methodResponses() {
        return this.methodResponses;
    }

    public Integration methodIntegration() {
        return this.methodIntegration;
    }

    public List<String> authorizationScopes() {
        return this.authorizationScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestValidatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestModels());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodIntegration());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationScopes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMethodResponse)) {
            return false;
        }
        UpdateMethodResponse other = (UpdateMethodResponse)((Object)obj);
        return Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.authorizationType(), other.authorizationType()) && Objects.equals(this.authorizerId(), other.authorizerId()) && Objects.equals(this.apiKeyRequired(), other.apiKeyRequired()) && Objects.equals(this.requestValidatorId(), other.requestValidatorId()) && Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.requestParameters(), other.requestParameters()) && Objects.equals(this.requestModels(), other.requestModels()) && Objects.equals(this.methodResponses(), other.methodResponses()) && Objects.equals(this.methodIntegration(), other.methodIntegration()) && Objects.equals(this.authorizationScopes(), other.authorizationScopes());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMethodResponse").add("HttpMethod", (Object)this.httpMethod()).add("AuthorizationType", (Object)this.authorizationType()).add("AuthorizerId", (Object)this.authorizerId()).add("ApiKeyRequired", (Object)this.apiKeyRequired()).add("RequestValidatorId", (Object)this.requestValidatorId()).add("OperationName", (Object)this.operationName()).add("RequestParameters", this.requestParameters()).add("RequestModels", this.requestModels()).add("MethodResponses", this.methodResponses()).add("MethodIntegration", (Object)this.methodIntegration()).add("AuthorizationScopes", this.authorizationScopes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "authorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationType()));
            }
            case "authorizerId": {
                return Optional.ofNullable(clazz.cast(this.authorizerId()));
            }
            case "apiKeyRequired": {
                return Optional.ofNullable(clazz.cast(this.apiKeyRequired()));
            }
            case "requestValidatorId": {
                return Optional.ofNullable(clazz.cast(this.requestValidatorId()));
            }
            case "operationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestModels": {
                return Optional.ofNullable(clazz.cast(this.requestModels()));
            }
            case "methodResponses": {
                return Optional.ofNullable(clazz.cast(this.methodResponses()));
            }
            case "methodIntegration": {
                return Optional.ofNullable(clazz.cast(this.methodIntegration()));
            }
            case "authorizationScopes": {
                return Optional.ofNullable(clazz.cast(this.authorizationScopes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMethodResponse, T> g) {
        return obj -> g.apply((UpdateMethodResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String httpMethod;
        private String authorizationType;
        private String authorizerId;
        private Boolean apiKeyRequired;
        private String requestValidatorId;
        private String operationName;
        private Map<String, Boolean> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, MethodResponse> methodResponses = DefaultSdkAutoConstructMap.getInstance();
        private Integration methodIntegration;
        private List<String> authorizationScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMethodResponse model) {
            super(model);
            this.httpMethod(model.httpMethod);
            this.authorizationType(model.authorizationType);
            this.authorizerId(model.authorizerId);
            this.apiKeyRequired(model.apiKeyRequired);
            this.requestValidatorId(model.requestValidatorId);
            this.operationName(model.operationName);
            this.requestParameters(model.requestParameters);
            this.requestModels(model.requestModels);
            this.methodResponses(model.methodResponses);
            this.methodIntegration(model.methodIntegration);
            this.authorizationScopes(model.authorizationScopes);
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        public final String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        public final Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        public final String getRequestValidatorId() {
            return this.requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public final Map<String, Boolean> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final Builder requestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
            return this;
        }

        public final void setRequestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
        }

        public final Map<String, String> getRequestModels() {
            return this.requestModels;
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
            return this;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
        }

        public final Map<String, MethodResponse.Builder> getMethodResponses() {
            return this.methodResponses != null ? CollectionUtils.mapValues(this.methodResponses, MethodResponse::toBuilder) : null;
        }

        @Override
        public final Builder methodResponses(Map<String, MethodResponse> methodResponses) {
            this.methodResponses = MapOfMethodResponseCopier.copy(methodResponses);
            return this;
        }

        public final void setMethodResponses(Map<String, MethodResponse.BuilderImpl> methodResponses) {
            this.methodResponses = MapOfMethodResponseCopier.copyFromBuilder(methodResponses);
        }

        public final Integration.Builder getMethodIntegration() {
            return this.methodIntegration != null ? this.methodIntegration.toBuilder() : null;
        }

        @Override
        public final Builder methodIntegration(Integration methodIntegration) {
            this.methodIntegration = methodIntegration;
            return this;
        }

        public final void setMethodIntegration(Integration.BuilderImpl methodIntegration) {
            this.methodIntegration = methodIntegration != null ? methodIntegration.build() : null;
        }

        public final Collection<String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final Builder authorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = ListOfStringCopier.copy(authorizationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationScopes(String ... authorizationScopes) {
            this.authorizationScopes(Arrays.asList(authorizationScopes));
            return this;
        }

        public final void setAuthorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = ListOfStringCopier.copy(authorizationScopes);
        }

        @Override
        public UpdateMethodResponse build() {
            return new UpdateMethodResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMethodResponse> {
        public Builder httpMethod(String var1);

        public Builder authorizationType(String var1);

        public Builder authorizerId(String var1);

        public Builder apiKeyRequired(Boolean var1);

        public Builder requestValidatorId(String var1);

        public Builder operationName(String var1);

        public Builder requestParameters(Map<String, Boolean> var1);

        public Builder requestModels(Map<String, String> var1);

        public Builder methodResponses(Map<String, MethodResponse> var1);

        public Builder methodIntegration(Integration var1);

        default public Builder methodIntegration(Consumer<Integration.Builder> methodIntegration) {
            return this.methodIntegration((Integration)((Integration.Builder)Integration.builder().applyMutation(methodIntegration)).build());
        }

        public Builder authorizationScopes(Collection<String> var1);

        public Builder authorizationScopes(String ... var1);
    }
}

