/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.Integration;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfMethodResponseCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToBooleanCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.services.apigateway.model.MethodResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMethodResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateMethodResponse> {
    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpMethod").getter(UpdateMethodResponse.getter(UpdateMethodResponse::httpMethod)).setter(UpdateMethodResponse.setter(Builder::httpMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpMethod").build()}).build();
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationType").getter(UpdateMethodResponse.getter(UpdateMethodResponse::authorizationType)).setter(UpdateMethodResponse.setter(Builder::authorizationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()}).build();
    private static final SdkField<String> AUTHORIZER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerId").getter(UpdateMethodResponse.getter(UpdateMethodResponse::authorizerId)).setter(UpdateMethodResponse.setter(Builder::authorizerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerId").build()}).build();
    private static final SdkField<Boolean> API_KEY_REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("apiKeyRequired").getter(UpdateMethodResponse.getter(UpdateMethodResponse::apiKeyRequired)).setter(UpdateMethodResponse.setter(Builder::apiKeyRequired)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeyRequired").build()}).build();
    private static final SdkField<String> REQUEST_VALIDATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestValidatorId").getter(UpdateMethodResponse.getter(UpdateMethodResponse::requestValidatorId)).setter(UpdateMethodResponse.setter(Builder::requestValidatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestValidatorId").build()}).build();
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationName").getter(UpdateMethodResponse.getter(UpdateMethodResponse::operationName)).setter(UpdateMethodResponse.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()}).build();
    private static final SdkField<Map<String, Boolean>> REQUEST_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestParameters").getter(UpdateMethodResponse.getter(UpdateMethodResponse::requestParameters)).setter(UpdateMethodResponse.setter(Builder::requestParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestModels").getter(UpdateMethodResponse.getter(UpdateMethodResponse::requestModels)).setter(UpdateMethodResponse.setter(Builder::requestModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, MethodResponse>> METHOD_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("methodResponses").getter(UpdateMethodResponse.getter(UpdateMethodResponse::methodResponses)).setter(UpdateMethodResponse.setter(Builder::methodResponses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodResponses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MethodResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integration> METHOD_INTEGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("methodIntegration").getter(UpdateMethodResponse.getter(UpdateMethodResponse::methodIntegration)).setter(UpdateMethodResponse.setter(Builder::methodIntegration)).constructor(Integration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("methodIntegration").build()}).build();
    private static final SdkField<List<String>> AUTHORIZATION_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authorizationScopes").getter(UpdateMethodResponse.getter(UpdateMethodResponse::authorizationScopes)).setter(UpdateMethodResponse.setter(Builder::authorizationScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_METHOD_FIELD, AUTHORIZATION_TYPE_FIELD, AUTHORIZER_ID_FIELD, API_KEY_REQUIRED_FIELD, REQUEST_VALIDATOR_ID_FIELD, OPERATION_NAME_FIELD, REQUEST_PARAMETERS_FIELD, REQUEST_MODELS_FIELD, METHOD_RESPONSES_FIELD, METHOD_INTEGRATION_FIELD, AUTHORIZATION_SCOPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("httpMethod", HTTP_METHOD_FIELD);
            this.put("authorizationType", AUTHORIZATION_TYPE_FIELD);
            this.put("authorizerId", AUTHORIZER_ID_FIELD);
            this.put("apiKeyRequired", API_KEY_REQUIRED_FIELD);
            this.put("requestValidatorId", REQUEST_VALIDATOR_ID_FIELD);
            this.put("operationName", OPERATION_NAME_FIELD);
            this.put("requestParameters", REQUEST_PARAMETERS_FIELD);
            this.put("requestModels", REQUEST_MODELS_FIELD);
            this.put("methodResponses", METHOD_RESPONSES_FIELD);
            this.put("methodIntegration", METHOD_INTEGRATION_FIELD);
            this.put("authorizationScopes", AUTHORIZATION_SCOPES_FIELD);
        }
    });
    private final String httpMethod;
    private final String authorizationType;
    private final String authorizerId;
    private final Boolean apiKeyRequired;
    private final String requestValidatorId;
    private final String operationName;
    private final Map<String, Boolean> requestParameters;
    private final Map<String, String> requestModels;
    private final Map<String, MethodResponse> methodResponses;
    private final Integration methodIntegration;
    private final List<String> authorizationScopes;

    private UpdateMethodResponse(BuilderImpl builder) {
        super(builder);
        this.httpMethod = builder.httpMethod;
        this.authorizationType = builder.authorizationType;
        this.authorizerId = builder.authorizerId;
        this.apiKeyRequired = builder.apiKeyRequired;
        this.requestValidatorId = builder.requestValidatorId;
        this.operationName = builder.operationName;
        this.requestParameters = builder.requestParameters;
        this.requestModels = builder.requestModels;
        this.methodResponses = builder.methodResponses;
        this.methodIntegration = builder.methodIntegration;
        this.authorizationScopes = builder.authorizationScopes;
    }

    public final String httpMethod() {
        return this.httpMethod;
    }

    public final String authorizationType() {
        return this.authorizationType;
    }

    public final String authorizerId() {
        return this.authorizerId;
    }

    public final Boolean apiKeyRequired() {
        return this.apiKeyRequired;
    }

    public final String requestValidatorId() {
        return this.requestValidatorId;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final boolean hasRequestParameters() {
        return this.requestParameters != null && !(this.requestParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Boolean> requestParameters() {
        return this.requestParameters;
    }

    public final boolean hasRequestModels() {
        return this.requestModels != null && !(this.requestModels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestModels() {
        return this.requestModels;
    }

    public final boolean hasMethodResponses() {
        return this.methodResponses != null && !(this.methodResponses instanceof SdkAutoConstructMap);
    }

    public final Map<String, MethodResponse> methodResponses() {
        return this.methodResponses;
    }

    public final Integration methodIntegration() {
        return this.methodIntegration;
    }

    public final boolean hasAuthorizationScopes() {
        return this.authorizationScopes != null && !(this.authorizationScopes instanceof SdkAutoConstructList);
    }

    public final List<String> authorizationScopes() {
        return this.authorizationScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiKeyRequired());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestValidatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestParameters() ? this.requestParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestModels() ? this.requestModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMethodResponses() ? this.methodResponses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.methodIntegration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizationScopes() ? this.authorizationScopes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMethodResponse)) {
            return false;
        }
        UpdateMethodResponse other = (UpdateMethodResponse)((Object)obj);
        return Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.authorizationType(), other.authorizationType()) && Objects.equals(this.authorizerId(), other.authorizerId()) && Objects.equals(this.apiKeyRequired(), other.apiKeyRequired()) && Objects.equals(this.requestValidatorId(), other.requestValidatorId()) && Objects.equals(this.operationName(), other.operationName()) && this.hasRequestParameters() == other.hasRequestParameters() && Objects.equals(this.requestParameters(), other.requestParameters()) && this.hasRequestModels() == other.hasRequestModels() && Objects.equals(this.requestModels(), other.requestModels()) && this.hasMethodResponses() == other.hasMethodResponses() && Objects.equals(this.methodResponses(), other.methodResponses()) && Objects.equals(this.methodIntegration(), other.methodIntegration()) && this.hasAuthorizationScopes() == other.hasAuthorizationScopes() && Objects.equals(this.authorizationScopes(), other.authorizationScopes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMethodResponse").add("HttpMethod", (Object)this.httpMethod()).add("AuthorizationType", (Object)this.authorizationType()).add("AuthorizerId", (Object)this.authorizerId()).add("ApiKeyRequired", (Object)this.apiKeyRequired()).add("RequestValidatorId", (Object)this.requestValidatorId()).add("OperationName", (Object)this.operationName()).add("RequestParameters", this.hasRequestParameters() ? this.requestParameters() : null).add("RequestModels", this.hasRequestModels() ? this.requestModels() : null).add("MethodResponses", this.hasMethodResponses() ? this.methodResponses() : null).add("MethodIntegration", (Object)this.methodIntegration()).add("AuthorizationScopes", this.hasAuthorizationScopes() ? this.authorizationScopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "httpMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "authorizationType": {
                return Optional.ofNullable(clazz.cast(this.authorizationType()));
            }
            case "authorizerId": {
                return Optional.ofNullable(clazz.cast(this.authorizerId()));
            }
            case "apiKeyRequired": {
                return Optional.ofNullable(clazz.cast(this.apiKeyRequired()));
            }
            case "requestValidatorId": {
                return Optional.ofNullable(clazz.cast(this.requestValidatorId()));
            }
            case "operationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "requestParameters": {
                return Optional.ofNullable(clazz.cast(this.requestParameters()));
            }
            case "requestModels": {
                return Optional.ofNullable(clazz.cast(this.requestModels()));
            }
            case "methodResponses": {
                return Optional.ofNullable(clazz.cast(this.methodResponses()));
            }
            case "methodIntegration": {
                return Optional.ofNullable(clazz.cast(this.methodIntegration()));
            }
            case "authorizationScopes": {
                return Optional.ofNullable(clazz.cast(this.authorizationScopes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMethodResponse, T> g) {
        return obj -> g.apply((UpdateMethodResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String httpMethod;
        private String authorizationType;
        private String authorizerId;
        private Boolean apiKeyRequired;
        private String requestValidatorId;
        private String operationName;
        private Map<String, Boolean> requestParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> requestModels = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, MethodResponse> methodResponses = DefaultSdkAutoConstructMap.getInstance();
        private Integration methodIntegration;
        private List<String> authorizationScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMethodResponse model) {
            super(model);
            this.httpMethod(model.httpMethod);
            this.authorizationType(model.authorizationType);
            this.authorizerId(model.authorizerId);
            this.apiKeyRequired(model.apiKeyRequired);
            this.requestValidatorId(model.requestValidatorId);
            this.operationName(model.operationName);
            this.requestParameters(model.requestParameters);
            this.requestModels(model.requestModels);
            this.methodResponses(model.methodResponses);
            this.methodIntegration(model.methodIntegration);
            this.authorizationScopes(model.authorizationScopes);
        }

        public final String getHttpMethod() {
            return this.httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getAuthorizationType() {
            return this.authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public final String getAuthorizerId() {
            return this.authorizerId;
        }

        public final void setAuthorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
        }

        @Override
        public final Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public final Boolean getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        public final void setApiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
        }

        @Override
        public final Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public final String getRequestValidatorId() {
            return this.requestValidatorId;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final Map<String, Boolean> getRequestParameters() {
            if (this.requestParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestParameters;
        }

        public final void setRequestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
        }

        @Override
        public final Builder requestParameters(Map<String, Boolean> requestParameters) {
            this.requestParameters = MapOfStringToBooleanCopier.copy(requestParameters);
            return this;
        }

        public final Map<String, String> getRequestModels() {
            if (this.requestModels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestModels;
        }

        public final void setRequestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
        }

        @Override
        public final Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = MapOfStringToStringCopier.copy(requestModels);
            return this;
        }

        public final Map<String, MethodResponse.Builder> getMethodResponses() {
            Map<String, MethodResponse.Builder> result = MapOfMethodResponseCopier.copyToBuilder(this.methodResponses);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMethodResponses(Map<String, MethodResponse.BuilderImpl> methodResponses) {
            this.methodResponses = MapOfMethodResponseCopier.copyFromBuilder(methodResponses);
        }

        @Override
        public final Builder methodResponses(Map<String, MethodResponse> methodResponses) {
            this.methodResponses = MapOfMethodResponseCopier.copy(methodResponses);
            return this;
        }

        public final Integration.Builder getMethodIntegration() {
            return this.methodIntegration != null ? this.methodIntegration.toBuilder() : null;
        }

        public final void setMethodIntegration(Integration.BuilderImpl methodIntegration) {
            this.methodIntegration = methodIntegration != null ? methodIntegration.build() : null;
        }

        @Override
        public final Builder methodIntegration(Integration methodIntegration) {
            this.methodIntegration = methodIntegration;
            return this;
        }

        public final Collection<String> getAuthorizationScopes() {
            if (this.authorizationScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizationScopes;
        }

        public final void setAuthorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = ListOfStringCopier.copy(authorizationScopes);
        }

        @Override
        public final Builder authorizationScopes(Collection<String> authorizationScopes) {
            this.authorizationScopes = ListOfStringCopier.copy(authorizationScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationScopes(String ... authorizationScopes) {
            this.authorizationScopes(Arrays.asList(authorizationScopes));
            return this;
        }

        @Override
        public UpdateMethodResponse build() {
            return new UpdateMethodResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMethodResponse> {
        public Builder httpMethod(String var1);

        public Builder authorizationType(String var1);

        public Builder authorizerId(String var1);

        public Builder apiKeyRequired(Boolean var1);

        public Builder requestValidatorId(String var1);

        public Builder operationName(String var1);

        public Builder requestParameters(Map<String, Boolean> var1);

        public Builder requestModels(Map<String, String> var1);

        public Builder methodResponses(Map<String, MethodResponse> var1);

        public Builder methodIntegration(Integration var1);

        default public Builder methodIntegration(Consumer<Integration.Builder> methodIntegration) {
            return this.methodIntegration((Integration)((Integration.Builder)Integration.builder().applyMutation(methodIntegration)).build());
        }

        public Builder authorizationScopes(Collection<String> var1);

        public Builder authorizationScopes(String ... var1);
    }
}

