/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.QuotaPeriodType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuotaSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuotaSettings> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(QuotaSettings.getter(QuotaSettings::limit)).setter(QuotaSettings.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("offset").getter(QuotaSettings.getter(QuotaSettings::offset)).setter(QuotaSettings.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()}).build();
    private static final SdkField<String> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("period").getter(QuotaSettings.getter(QuotaSettings::periodAsString)).setter(QuotaSettings.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, OFFSET_FIELD, PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("limit", LIMIT_FIELD);
            this.put("offset", OFFSET_FIELD);
            this.put("period", PERIOD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer limit;
    private final Integer offset;
    private final String period;

    private QuotaSettings(BuilderImpl builder) {
        this.limit = builder.limit;
        this.offset = builder.offset;
        this.period = builder.period;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final Integer offset() {
        return this.offset;
    }

    public final QuotaPeriodType period() {
        return QuotaPeriodType.fromValue(this.period);
    }

    public final String periodAsString() {
        return this.period;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaSettings)) {
            return false;
        }
        QuotaSettings other = (QuotaSettings)obj;
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.periodAsString(), other.periodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QuotaSettings").add("Limit", (Object)this.limit()).add("Offset", (Object)this.offset()).add("Period", (Object)this.periodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "period": {
                return Optional.ofNullable(clazz.cast(this.periodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuotaSettings, T> g) {
        return obj -> g.apply((QuotaSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer limit;
        private Integer offset;
        private String period;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaSettings model) {
            this.limit(model.limit);
            this.offset(model.offset);
            this.period(model.period);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final String getPeriod() {
            return this.period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(QuotaPeriodType period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public QuotaSettings build() {
            return new QuotaSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuotaSettings> {
        public Builder limit(Integer var1);

        public Builder offset(Integer var1);

        public Builder period(String var1);

        public Builder period(QuotaPeriodType var1);
    }
}

