/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.ApiGatewayClientBuilder;
import software.amazon.awssdk.services.apigateway.ApiGatewayServiceClientConfiguration;
import software.amazon.awssdk.services.apigateway.DefaultApiGatewayBaseClientBuilder;
import software.amazon.awssdk.services.apigateway.DefaultApiGatewayClient;
import software.amazon.awssdk.services.apigateway.endpoints.ApiGatewayEndpointProvider;

@SdkInternalApi
final class DefaultApiGatewayClientBuilder
extends DefaultApiGatewayBaseClientBuilder<ApiGatewayClientBuilder, ApiGatewayClient>
implements ApiGatewayClientBuilder {
    DefaultApiGatewayClientBuilder() {
    }

    @Override
    public DefaultApiGatewayClientBuilder endpointProvider(ApiGatewayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApiGatewayClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultApiGatewayClientBuilder.validateClientOptions(clientConfiguration);
        ApiGatewayServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultApiGatewayClient client = new DefaultApiGatewayClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ApiGatewayServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ApiGatewayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

