/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.ApiGatewayClientBuilder;
import software.amazon.awssdk.services.apigateway.ApiGatewayServiceClientConfiguration;
import software.amazon.awssdk.services.apigateway.DefaultApiGatewayBaseClientBuilder;
import software.amazon.awssdk.services.apigateway.DefaultApiGatewayClient;
import software.amazon.awssdk.services.apigateway.endpoints.ApiGatewayEndpointProvider;

@SdkInternalApi
final class DefaultApiGatewayClientBuilder
extends DefaultApiGatewayBaseClientBuilder<ApiGatewayClientBuilder, ApiGatewayClient>
implements ApiGatewayClientBuilder {
    DefaultApiGatewayClientBuilder() {
    }

    @Override
    public DefaultApiGatewayClientBuilder endpointProvider(ApiGatewayEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ApiGatewayClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultApiGatewayClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ApiGatewayServiceClientConfiguration serviceClientConfiguration = ApiGatewayServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultApiGatewayClient(serviceClientConfiguration, clientConfiguration);
    }
}

