/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayAsyncClient;
import software.amazon.awssdk.services.apigateway.model.GetModelsRequest;
import software.amazon.awssdk.services.apigateway.model.GetModelsResponse;
import software.amazon.awssdk.services.apigateway.model.Model;

public class GetModelsPublisher
implements SdkPublisher<GetModelsResponse> {
    private final ApiGatewayAsyncClient client;
    private final GetModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetModelsPublisher(ApiGatewayAsyncClient client, GetModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetModelsPublisher(ApiGatewayAsyncClient client, GetModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Model> items() {
        Function<GetModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetModelsResponseFetcher
    implements AsyncPageFetcher<GetModelsResponse> {
        private GetModelsResponseFetcher() {
        }

        public boolean hasNextPage(GetModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public CompletableFuture<GetModelsResponse> nextPage(GetModelsResponse previousPage) {
            if (previousPage == null) {
                return GetModelsPublisher.this.client.getModels(GetModelsPublisher.this.firstRequest);
            }
            return GetModelsPublisher.this.client.getModels((GetModelsRequest)((Object)GetModelsPublisher.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

