/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.ClientCertificate;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesRequest;
import software.amazon.awssdk.services.apigateway.model.GetClientCertificatesResponse;

public class GetClientCertificatesIterable
implements SdkIterable<GetClientCertificatesResponse> {
    private final ApiGatewayClient client;
    private final GetClientCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetClientCertificatesIterable(ApiGatewayClient client, GetClientCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetClientCertificatesResponseFetcher();
    }

    public Iterator<GetClientCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClientCertificate> items() {
        Function<GetClientCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetClientCertificatesResponseFetcher
    implements SyncPageFetcher<GetClientCertificatesResponse> {
        private GetClientCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(GetClientCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetClientCertificatesResponse nextPage(GetClientCertificatesResponse previousPage) {
            if (previousPage == null) {
                return GetClientCertificatesIterable.this.client.getClientCertificates(GetClientCertificatesIterable.this.firstRequest);
            }
            return GetClientCertificatesIterable.this.client.getClientCertificates((GetClientCertificatesRequest)((Object)GetClientCertificatesIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

